/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.FreeList;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtil {
    private static FreeList<Random> _freeRandomList = new FreeList(64);
    private static Random _testRandom;

    public static long getRandomLong() {
        Random random = RandomUtil.getRandom();
        long value = random.nextLong();
        RandomUtil.freeRandom(random);
        return value;
    }

    public static int nextInt(int n) {
        Random random = RandomUtil.getRandom();
        int value = random.nextInt(n);
        RandomUtil.freeRandom(random);
        return value;
    }

    public static double nextDouble() {
        Random random = RandomUtil.getRandom();
        double value = random.nextDouble();
        RandomUtil.freeRandom(random);
        return value;
    }

    private static Random getRandom() {
        Random random = _freeRandomList.allocate();
        if (random != null) {
            return random;
        }
        if (_testRandom != null) {
            return _testRandom;
        }
        return new SecureRandom();
    }

    private static void freeRandom(Random random) {
        _freeRandomList.free(random);
    }

    public static void setTestSeed(long seed) {
        _testRandom = new Random(seed);
        while (_freeRandomList.allocate() != null) {
        }
    }
}

