/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.inject.Module;
import com.caucho.loader.Environment;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class JniTroubleshoot {
    private static final Logger log = Logger.getLogger(JniTroubleshoot.class.getName());
    private static final L10N L = new L10N(JniTroubleshoot.class);
    private static final HashSet<String> _loggedLibraries = new HashSet();
    private String _className;
    private String _libraryName;
    private Throwable _cause;
    private boolean _isValid;

    public JniTroubleshoot(Class<?> cl, String libraryName) {
        this._className = cl.getName();
        this._libraryName = libraryName;
        this._isValid = true;
    }

    public JniTroubleshoot(Class<?> cl, String libraryName, Throwable cause) {
        this._className = cl.getName();
        this._libraryName = libraryName;
        this._cause = cause;
        this._isValid = false;
    }

    public static String getPath(String name) {
        Path lib = JniTroubleshoot.getLib(name);
        if (lib.exists()) {
            return lib.getNativePath();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        if (!this._isValid && Environment.isLoggingInitialized()) {
            boolean isLogged = false;
            HashSet<String> hashSet = _loggedLibraries;
            synchronized (hashSet) {
                isLogged = _loggedLibraries.contains(this._libraryName);
                if (!isLogged) {
                    _loggedLibraries.add(this._libraryName);
                }
            }
            if (!isLogged) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.getMessage(), this._cause);
                } else {
                    log.warning(this.getMessage());
                }
            }
        }
    }

    public String getMessage() {
        Path lib = this.getLib();
        if (!lib.exists()) {
            if (JniTroubleshoot.isMacOSX()) {
                return L.l("Unable to find native library '{0}' for {1}. Resin expects to find this library in:\n  (Mac OS X) {2}\nOn Mac OS X, run ./configure --prefix=`pwd`; make; make install.\nThe JVM exception was: {3}\n", (Object)this._libraryName, (Object)this._className, (Object)lib.getNativePath(), (Object)this._cause);
            }
            if (JniTroubleshoot.isWin()) {
                return L.l("Unable to find native library '{0}' for {1}. Resin expects to find this library in:\n  (Windows) {2}\nOn Windows, check your installation for the DLL above.\nThe JVM exception was: {3}\n", (Object)this._libraryName, (Object)this._className, (Object)lib.getNativePath(), (Object)this._cause);
            }
            return L.l("Unable to find native library '{0}' for {1}. Resin expects to find this library in:\n  (Unix) {2}\nOn Unix, run ./configure --prefix=`pwd`; make; make install.\n\nThe JVM exception was: {3}\n", (Object)this._libraryName, (Object)this._className, (Object)lib.getNativePath(), (Object)this._cause);
        }
        if (this._cause == null) {
            return null;
        }
        return L.l("Found library '{0}' as '{1}', but the load failed. The JVM exception was: {2}\n", (Object)this._libraryName, (Object)lib.getNativePath(), (Object)this._cause);
    }

    public void checkIsValid() {
        if (!this._isValid) {
            throw new IllegalStateException(this.getMessage(), this._cause);
        }
    }

    public boolean isEnabled() {
        this.log();
        return this._isValid;
    }

    public void disable(Throwable cause) {
        if (this._cause == null) {
            this._cause = cause;
        }
        this._isValid = false;
    }

    public Throwable getCause() {
        return this._cause;
    }

    private static boolean isMacOSX() {
        return System.getProperty("os.name").equals("Mac OS X");
    }

    private static boolean isWin() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private Path getLib() {
        Path libexec = JniTroubleshoot.getLibexec();
        if (JniTroubleshoot.isMacOSX()) {
            return libexec.lookup("lib" + this._libraryName + ".jnilib");
        }
        if (JniTroubleshoot.isWin()) {
            return libexec.lookup(this._libraryName + ".dll");
        }
        return libexec.lookup("lib" + this._libraryName + ".so");
    }

    private static Path getLib(String libraryName) {
        Path libexec = JniTroubleshoot.getLibexec();
        if (JniTroubleshoot.isMacOSX()) {
            return libexec.lookup("lib" + libraryName + ".jnilib");
        }
        if (JniTroubleshoot.isWin()) {
            return libexec.lookup(libraryName + ".dll");
        }
        return libexec.lookup("lib" + libraryName + ".so");
    }

    private static Path getLibexec() {
        Path resinHome = CauchoSystem.getResinHome();
        if (JniTroubleshoot.isWin()) {
            if (CauchoSystem.is64Bit()) {
                return resinHome.lookup("win64");
            }
            return resinHome.lookup("win32");
        }
        if (CauchoSystem.is64Bit()) {
            return resinHome.lookup("libexec64");
        }
        return resinHome.lookup("libexec");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._libraryName + "," + this._isValid + "]";
    }
}

