/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class IntSet {
    int[] data;
    int size;

    public void clear() {
        this.size = 0;
    }

    private void expand(int max) {
        while (max > this.data.length) {
            int[] next = new int[this.data.length * 2];
            for (int i = 0; i < this.data.length; ++i) {
                next[i] = this.data[i];
            }
            this.data = next;
        }
    }

    public int length() {
        return this.size / 2;
    }

    public int size() {
        return this.size / 2;
    }

    public int getMin(int i) {
        return this.data[2 * i];
    }

    public int getMax(int i) {
        return this.data[2 * i + 1];
    }

    private void insert(int i, int min, int max) {
        this.expand(this.size + 2);
        System.arraycopy(this.data, i, this.data, i + 2, this.size - i);
        this.data[i] = min;
        this.data[i + 1] = max;
        this.size += 2;
    }

    private void delete(int i) {
        System.arraycopy(this.data, i + 2, this.data, i, this.size - i - 2);
        this.size -= 2;
    }

    public void union(int min, int max) {
        for (int i = 1; i < this.size; i += 2) {
            if (max < this.data[i - 1] - 1) {
                this.insert(i - 1, min, max);
                return;
            }
            if (min > this.data[i] + 1) continue;
            if (min < this.data[i - 1]) {
                this.data[i - 1] = min;
            }
            if (max > this.data[i]) {
                this.data[i] = max;
            }
            int j = i + 2;
            while (j < this.size && max > this.data[j - 1] + 1) {
                if (max < this.data[j - 1]) {
                    this.data[i] = this.data[j - 1];
                }
                this.delete(j - 1);
            }
            return;
        }
        this.insert(this.size, min, max);
    }

    public void union(int value) {
        this.union(value, value);
    }

    public void union(IntSet set) {
        for (int i = 1; i < set.size; i += 2) {
            this.union(set.data[i - 1], set.data[i]);
        }
    }

    public void unionNegate(IntSet set, int min, int max) {
        for (int i = 1; i < set.size; i += 2) {
            this.union(min, set.data[i - 1] - 1);
            min = set.data[i] + 1;
        }
        this.union(min, max);
    }

    public void negate(int minValue, int maxValue) {
        int max = minValue;
        if (this.size > 0 && this.data[0] == minValue) {
            max = this.data[1];
            this.delete(0);
            if (max == maxValue) {
                return;
            }
            ++max;
        }
        for (int i = 1; i < this.size; i += 2) {
            int newMax = this.data[i];
            this.data[i] = this.data[i - 1] - 1;
            this.data[i - 1] = max;
            if (newMax == maxValue) {
                return;
            }
            max = newMax + 1;
        }
        this.insert(this.size, max, maxValue);
    }

    public void negate() {
        this.negate(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public boolean difference(IntSet set) {
        int i = 1;
        int j = 1;
        while (i < this.size && j < set.size) {
            int aMin = this.data[i - 1];
            int aMax = this.data[i];
            int bMin = set.data[j - 1];
            int bMax = set.data[j];
            if (bMax < aMin) {
                j += 2;
                continue;
            }
            if (aMax < bMin) {
                i += 2;
                continue;
            }
            if (bMin <= aMin && aMax <= bMax) {
                this.delete(i - 1);
                continue;
            }
            if (aMin < bMin && bMax < aMax) {
                this.insert(i + 1, bMax + 1, aMax);
                this.data[i] = bMin - 1;
                i += 2;
                j += 2;
                continue;
            }
            if (aMin < bMin) {
                this.data[i] = bMin - 1;
                i += 2;
                continue;
            }
            if (aMax > bMax) {
                this.data[i - 1] = bMax + 1;
                j += 2;
                continue;
            }
            throw new RuntimeException("Impossible case");
        }
        return this.size != 0;
    }

    public boolean intersection(IntSet set) {
        int i = 1;
        int j = 1;
        while (i < this.size && j < set.size) {
            int aMin = this.data[i - 1];
            int aMax = this.data[i];
            int bMin = set.data[j - 1];
            int bMax = set.data[j];
            if (bMax < aMin) {
                j += 2;
                continue;
            }
            if (aMax < bMin) {
                this.delete(i - 1);
                continue;
            }
            if (bMin <= aMin && aMax <= bMax) {
                i += 2;
                continue;
            }
            if (aMin <= bMin && bMax <= aMax) {
                this.data[i - 1] = bMin;
                this.data[i] = bMax;
                if (bMax < aMax) {
                    this.insert(i + 1, bMax + 1, aMax);
                }
                i += 2;
                j += 2;
                continue;
            }
            if (aMin <= bMin) {
                this.data[i - 1] = bMin;
                i += 2;
                continue;
            }
            if (bMin < aMin) {
                this.data[i] = bMax;
                this.insert(i + 1, bMax + 1, aMax);
                i += 2;
                continue;
            }
            throw new RuntimeException("case");
        }
        while (i < this.size) {
            this.delete(i - 1);
        }
        return this.size != 0;
    }

    public boolean contains(int test) {
        for (int i = 1; i < this.size; i += 2) {
            if (test < this.data[i - 1]) {
                return false;
            }
            if (test > this.data[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isSubset(IntSet subset) {
        int i = 1;
        int j = 1;
        while (i < this.size && j < subset.size) {
            if (this.data[i] < subset.data[j - 1]) {
                i += 2;
                continue;
            }
            if (subset.data[j - 1] < this.data[i - 1] || subset.data[j] > this.data[i]) {
                return false;
            }
            j += 2;
        }
        return true;
    }

    public boolean isDisjoint(IntSet set) {
        int i = 1;
        int j = 1;
        while (i < this.size && j < set.size) {
            if (this.data[i] < set.data[j - 1]) {
                i += 2;
                continue;
            }
            if (set.data[j] < this.data[i - 1]) {
                j += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("IntSet[");
        for (int i = 1; i < this.size; ++i) {
            if (i != 1) {
                sbuf.append(" ");
            }
            sbuf.append(this.data[i - 1]);
            if (this.data[i - 1] == this.data[i]) continue;
            sbuf.append(",");
            sbuf.append(this.data[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public Object clone() {
        IntSet set = new IntSet(false);
        set.data = new int[this.data.length];
        set.size = this.size;
        System.arraycopy(this.data, 0, set.data, 0, this.size);
        return set;
    }

    private IntSet(boolean dummy) {
    }

    public IntSet() {
        this.data = new int[16];
        this.size = 0;
    }
}

