/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class IntMap {
    private static final Object NULL_KEY = new Object();
    public static final int NULL = -65536;
    private static int DELETED = 1;
    private final Item[] _entries;
    private final int _mask;
    private int _size;

    public IntMap() {
        this(256);
    }

    public IntMap(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._entries = new Item[capacity];
        this._mask = capacity - 1;
    }

    private IntMap(Item[] entries) {
        this._entries = new Item[entries.length];
        this._mask = this._entries.length - 1;
        for (Item item : entries) {
            while (item != null) {
                this.put(item._key, item._value);
                item = item._next;
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this._entries.length; ++i) {
            this._entries[i] = null;
        }
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public int get(Object key) {
        if (key == null) {
            key = NULL_KEY;
        }
        int hash = key.hashCode() & this._mask;
        Item item = this._entries[hash];
        while (item != null) {
            Object itemKey = item._key;
            if (itemKey == key || itemKey.equals(key)) {
                return item._value;
            }
            item = item._next;
        }
        return -65536;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put(Object key, int value) {
        if (key == null) {
            key = NULL_KEY;
        }
        IntMap intMap = this;
        synchronized (intMap) {
            int hash = key.hashCode() & this._mask;
            Item item = this._entries[hash];
            while (item != null) {
                Object testKey = item._key;
                if (testKey == key || testKey.equals(key)) {
                    int oldValue = item._value;
                    item._value = value;
                    return oldValue;
                }
                item = item._next;
            }
            item = new Item(key, value);
            item._next = this._entries[hash];
            this._entries[hash] = item;
            ++this._size;
        }
        return -65536;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(Object key) {
        if (key == null) {
            key = NULL_KEY;
        }
        int hash = key.hashCode() & this._mask;
        IntMap intMap = this;
        synchronized (intMap) {
            Item prev = null;
            Item item = this._entries[hash];
            while (item != null) {
                Object itemKey = item._key;
                if (itemKey == key || itemKey.equals(key)) {
                    int oldValue = item._value;
                    if (prev != null) {
                        prev._next = item._next;
                    } else {
                        this._entries[hash] = item._next;
                    }
                    --this._size;
                    return oldValue;
                }
                prev = item;
                item = item._next;
            }
        }
        return -65536;
    }

    public Iterator iterator() {
        return new IntMapIterator();
    }

    public Object clone() {
        return new IntMap(this._entries);
    }

    public String toString() {
        return "IntMap[]";
    }

    static class Item {
        final Object _key;
        int _value;
        Item _next;

        Item(Object key, int value) {
            this._key = key;
            this._value = value;
        }
    }

    class IntMapIterator
    implements Iterator {
        int _index = -1;
        Item _item;

        IntMapIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this._item != null) {
                return true;
            }
            ++this._index;
            while (this._index < IntMap.this._entries.length) {
                this._item = IntMap.this._entries[this._index];
                if (this._item != null) {
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        public Object next() {
            if (this._item != null) {
                Object key = this._item._key;
                this._item = this._item._next;
                return key;
            }
            ++this._index;
            while (this._index < IntMap.this._entries.length) {
                this._item = IntMap.this._entries[this._index];
                if (this._item != null) {
                    Object key = this._item._key;
                    this._item = this._item._next;
                    return key;
                }
                ++this._index;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new RuntimeException();
        }
    }
}

