/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

public class ConcurrentArrayList<E>
extends AbstractCollection<E> {
    private final Class<?> _type;
    private final ArrayList<E> _list = new ArrayList();
    private E[] _array;

    public ConcurrentArrayList(Class<E> type) {
        this._type = type;
        this.updateArray();
    }

    @Override
    public int size() {
        return this._array.length;
    }

    public E get(int index) {
        return this._array[index];
    }

    @Override
    public boolean contains(Object testValue) {
        for (E element : this._array) {
            if (!element.equals(testValue)) continue;
            return true;
        }
        return false;
    }

    public <K> E find(K key, Match<E, K> match) {
        for (E element : this._array) {
            if (!match.isMatch(element, key)) continue;
            return element;
        }
        return null;
    }

    public <K> int indexOf(K key, Match<E, K> match) {
        E[] array = this._array;
        for (int i = 0; i < array.length; ++i) {
            if (!match.isMatch(array[i], key)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E value) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            this._list.add(value);
            this.updateArray();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E addIfAbsent(E value) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            int index = this._list.indexOf(value);
            if (index >= 0) {
                return this._list.get(index);
            }
            this._list.add(value);
            this.updateArray();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> E addIfAbsent(E value, Match<E, K> match, K key) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            E oldValue = this.find(key, match);
            if (oldValue != null) {
                return oldValue;
            }
            this.add(value);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E set(int index, E value) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            while (this._list.size() <= index) {
                this._list.add(null);
            }
            E oldValue = this._list.set(index, value);
            this.updateArray();
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            boolean result = this._list.remove(value);
            this.updateArray();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(int index) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            E value = this._list.remove(index);
            this.updateArray();
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> E remove(K key, Match<E, K> match) {
        ArrayList<E> arrayList = this._list;
        synchronized (arrayList) {
            int index = this.indexOf(key, match);
            if (index < 0) {
                return null;
            }
            E value = this._array[index];
            this._list.remove(index);
            this.updateArray();
            return value;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this._array);
    }

    @Override
    public E[] toArray() {
        return this._array;
    }

    private void updateArray() {
        Object[] array = (Object[])Array.newInstance(this._type, this._list.size());
        this._list.toArray(array);
        this._array = array;
    }

    public static Class<?> calculateType(Class<?> cl) {
        return ConcurrentArrayList.calculateType(cl, cl);
    }

    public static Class<?> calculateType(Class<?> topClass, Class<?> cl) {
        if (cl == null) {
            throw new UnsupportedOperationException(topClass.toString());
        }
        Type type = cl.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getActualTypeArguments()[0];
        }
        return ConcurrentArrayList.calculateType(topClass, cl.getSuperclass());
    }

    public static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] _array;
        int _index;

        ArrayIterator(E[] array) {
            this._array = array;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._array.length;
        }

        @Override
        public E next() {
            if (this._index < this._array.length) {
                return this._array[this._index++];
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public static interface Match<E, K> {
        public boolean isMatch(E var1, K var2);
    }
}

