/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.GroupPattern;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.AttributeItem;
import com.caucho.relaxng.program.Item;

public class AttributePattern
extends Pattern {
    private NameClassPattern _name;
    private Pattern _children;
    private Item _item;

    @Override
    public String getTagName() {
        return "attribute";
    }

    @Override
    public void addNameChild(NameClassPattern child) throws RelaxException {
        this._name = child;
        this.setElementName(this._name.toProduction());
    }

    public NameClassPattern getNameChild() throws RelaxException {
        return this._name;
    }

    @Override
    public void addChild(Pattern child) throws RelaxException {
        if (this._name == null) {
            throw new RelaxException(L.l("<attribute> must have a <name> definition before any children."));
        }
        child.setParent(this._children);
        if (this._children == null) {
            this._children = child;
        } else if (this._children instanceof GroupPattern) {
            GroupPattern group = (GroupPattern)this._children;
            group.addChild(child);
        } else {
            GroupPattern group = new GroupPattern();
            group.addChild(this._children);
            group.addChild(child);
            this._children = group;
        }
    }

    @Override
    public void endElement() throws RelaxException {
        if (this._name == null) {
            throw new RelaxException(L.l("<attribute> must have a <name> definition."));
        }
    }

    @Override
    public Item createItem(GrammarPattern grammar) throws RelaxException {
        if (this._item == null) {
            this._item = new AttributeItem(this._name.createNameItem());
        }
        return this._item;
    }

    @Override
    public String toProduction() {
        return "@" + this._name.toProduction();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributePattern)) {
            return false;
        }
        AttributePattern elt = (AttributePattern)o;
        if (!this._name.equals(elt._name)) {
            return false;
        }
        if (this._children == elt._children) {
            return true;
        }
        if (this._children == null || elt._children == null) {
            return false;
        }
        return this._children.equals(elt._children);
    }

    public String toString() {
        return "AttributePattern[" + this._name.toProduction() + "]";
    }
}

