/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class PathJndiContext
implements Context {
    private static L10N L = new L10N(PathJndiContext.class);
    private PathJndiContext _root;
    private Path _path;

    public PathJndiContext(Path path) {
        this._root = this;
        this._path = path;
    }

    PathJndiContext(Path path, PathJndiContext root) {
        this._root = root;
        this._path = path;
        if (root == null) {
            this._root = root;
        }
    }

    public Path getPath() {
        return this._path;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null || name.equals("")) {
            return new PathJndiContext(this._path.lookup((String)null), this._root);
        }
        Path subpath = this._path.lookup(name);
        if (subpath == null) {
            throw new NamingException(L.l("bad path {0}", (Object)name));
        }
        if (subpath.isDirectory()) {
            return new PathJndiContext(subpath, this._root);
        }
        if (subpath.isObject()) {
            try {
                return subpath.getValue();
            }
            catch (Exception e) {
                throw new NamingException(e.toString());
            }
        }
        if (!subpath.exists()) {
            return null;
        }
        throw new NamingException(L.l("lookup can't handle files"));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Path subpath = this._path.lookup(name);
        Path parent = subpath.getParent();
        if (!parent.exists()) {
            try {
                parent.mkdirs();
            }
            catch (IOException e) {
                throw new NamingException(e.toString());
            }
        }
        if (!parent.isDirectory()) {
            throw new NamingException(L.l("bind expects directory for `{0}'", (Object)subpath.getParent()));
        }
        if (subpath.exists()) {
            throw new NameAlreadyBoundException(L.l("`{0}' already has a binding", (Object)subpath));
        }
        try {
            subpath.setValue(obj);
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Path subpath = this._path.lookup(name);
        try {
            Path parent = subpath.getParent();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            subpath.setValue(obj);
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        Path subpath = this._path.lookup(name);
        try {
            subpath.remove();
        }
        catch (IOException e) {
            throw new NamingException(L.l("can't remove `{0}'"));
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Path subpath = this._path.lookup(name);
        if (!subpath.exists()) {
            throw new NameNotFoundException(name);
        }
        if (!subpath.isDirectory()) {
            throw new NotContextException(name);
        }
        try {
            subpath.remove();
        }
        catch (IOException e) {
            throw new ContextNotEmptyException(name);
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Path subpath = this._path.lookup(name);
        if (!subpath.getParent().isDirectory()) {
            throw new NamingException(L.l("parent of `{0}' must be directory", (Object)name));
        }
        try {
            subpath.mkdir();
        }
        catch (IOException e) {
            throw new ContextNotEmptyException(name);
        }
        return new PathJndiContext(subpath, this._root);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new NamingException(L.l("links not supported"));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new PathNameParser();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String suffix, String prefix) throws NamingException {
        return prefix + "/" + suffix;
    }

    @Override
    public Name composeName(Name suffix, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this._path.getPath();
    }

    @Override
    public Object addToEnvironment(String prop, Object value) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeFromEnvironment(String prop) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Hashtable getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    static class PathNameParser
    implements NameParser {
        PathNameParser() {
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    }
}

