/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class LinkProxy
implements ObjectProxy,
Serializable {
    private static Logger log = Logger.getLogger(LinkProxy.class.getName());
    private static L10N L = new L10N(LinkProxy.class);
    protected InitialContextFactory _factory;
    protected Class _factoryClass;
    protected Hashtable<String, String> _props = new Hashtable();
    protected String _jndiName;
    protected String _jndiLocalName;
    protected String _foreignName;

    public LinkProxy() throws NamingException {
    }

    public LinkProxy(InitialContextFactory factory, Hashtable<String, String> props, String name) throws NamingException {
        if (factory == null) {
            throw new NullPointerException();
        }
        this._factory = factory;
        this._props = props;
        this._foreignName = name;
    }

    public LinkProxy(String name) throws NamingException {
        this._foreignName = name;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public void setJndiLocalName(String name) {
        this._jndiLocalName = name;
    }

    public void setName(String name) {
        this.setJndiName(name);
    }

    public void setFactory(Class factoryClass) {
        this._factoryClass = factoryClass;
    }

    public void setJndiFactory(Class factoryClass) {
        this.setFactory(factoryClass);
    }

    public void setForeignName(String name) {
        this._foreignName = name;
    }

    public void addInitParam(InitParam initParam) {
        if (this._props == null) {
            this._props = new Hashtable();
        }
        this._props.putAll(initParam.getParameters());
    }

    public Object createObject(Hashtable env) throws NamingException {
        Hashtable<String, String> mergeEnv = new Hashtable<String, String>();
        if (env != null && env.size() > 0) {
            mergeEnv.putAll(env);
        }
        if (this._props != null && this._props.size() > 0) {
            mergeEnv.putAll(this._props);
        }
        InitialContext context = new InitialContext(mergeEnv);
        if (this._foreignName != null) {
            String foreignName = this._factoryClass != null ? this._foreignName : Jndi.getFullName(this._foreignName);
            try {
                Object value = context.lookup(foreignName);
                return value;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
        }
        return context;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this._jndiName == null && this._jndiLocalName == null) {
            throw new ConfigException(L.l("<jndi-link> configuration needs a <jndi-name>.  The <jndi-name> is the JNDI name where the context will be linked."));
        }
        Class factoryClass = this._factoryClass;
        if (factoryClass != null) {
            if (this._props == null) {
                this._props = new Hashtable();
            }
            this._props.put("java.naming.factory.initial", factoryClass.getName());
        }
        if (log.isLoggable(Level.CONFIG)) {
            if (this._foreignName != null) {
                log.config("jndi-link[jndi-name=" + this._jndiName + ", foreign-name=" + this._foreignName + "] configured");
            } else if (this._factoryClass != null) {
                log.config("jndi-link[jndi-name=" + this._jndiName + ", factory=" + this._factoryClass.getName() + "] configured");
            }
        }
        if (this._foreignName != null && Jndi.getFullName(this._jndiName).equals(Jndi.getFullName(this._foreignName))) {
            return;
        }
        if (this._jndiLocalName != null) {
            Jndi.rebindDeep(this._jndiLocalName, this);
        } else {
            Jndi.rebindDeepShort(this._jndiName, this);
        }
    }

    public String toString() {
        if (this._factoryClass != null) {
            return "LinkProxy[name=" + this._jndiName + ",factory=" + this._factoryClass.getName() + "]";
        }
        return "LinkProxy[name=" + this._jndiName + ",foreign=" + this._foreignName + "]";
    }
}

