/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.naming.EnvironmentModel;
import java.util.concurrent.ConcurrentHashMap;

public class EnvironmentModelRoot {
    private static final EnvironmentLocal<EnvironmentModelRoot> _local = new EnvironmentLocal();
    private final ClassLoader _loader;
    private ConcurrentHashMap<String, EnvironmentModel> _map = new ConcurrentHashMap();

    private EnvironmentModelRoot(ClassLoader loader) {
        while (loader != null && !(loader instanceof EnvironmentClassLoader)) {
            loader = loader.getParent();
        }
        this._loader = loader;
        this._map.put("", new EnvironmentModel(this, ""));
    }

    public static EnvironmentModelRoot getCurrent() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        return EnvironmentModelRoot.getCurrent(loader);
    }

    public static EnvironmentModelRoot getCurrent(ClassLoader loader) {
        return _local.get(loader);
    }

    public static EnvironmentModelRoot create() {
        return EnvironmentModelRoot.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnvironmentModelRoot create(ClassLoader loader) {
        EnvironmentLocal<EnvironmentModelRoot> environmentLocal = _local;
        synchronized (environmentLocal) {
            EnvironmentModelRoot root = _local.getLevel(loader);
            if (root == null) {
                root = new EnvironmentModelRoot(loader);
                _local.set(root, loader);
            }
            return root;
        }
    }

    protected ClassLoader getClassLoader() {
        return this._loader;
    }

    public EnvironmentModel get(String path) {
        return this._map.get(path);
    }

    public EnvironmentModel put(String path, EnvironmentModel value) {
        return this._map.put(path, value);
    }

    public EnvironmentModel remove(String path) {
        return this._map.remove(path);
    }
}

