/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.log.AbstractLogHandler;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class StreamHandler
extends AbstractLogHandler {
    private static final L10N L = new L10N(StreamHandler.class);
    private WriteStream _os;
    private Formatter _formatter;
    private String _timestamp;
    private boolean _isNullDelimited;

    public StreamHandler() {
    }

    public StreamHandler(WriteStream os) {
        this._os = os;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void setNullDelimited(boolean isNullDelimited) {
        this._isNullDelimited = isNullDelimited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPublish(LogRecord record) {
        WriteStream os;
        if (!this.isLoggable(record)) {
            return;
        }
        WriteStream writeStream = os = this._os;
        synchronized (writeStream) {
            try {
                if (record == null) {
                    os.println("no record");
                    if (this._isNullDelimited) {
                        os.write(0);
                    }
                    return;
                }
                if (this._formatter != null) {
                    String value = this._formatter.format(record);
                    os.println(value);
                    if (this._isNullDelimited) {
                        os.write(0);
                    }
                    return;
                }
                String message = record.getMessage();
                Throwable thrown = record.getThrown();
                if (thrown == null && message != null && message.indexOf("java.lang.NullPointerException") >= 0) {
                    thrown = new IllegalStateException();
                    thrown.fillInStackTrace();
                }
                if (this._timestamp != null) {
                    os.print(this._timestamp);
                }
                if (thrown != null) {
                    if (message != null && !message.equals(thrown.toString()) && !message.equals(thrown.getMessage())) {
                        this.printMessage(os, message, record.getParameters());
                    }
                    thrown.printStackTrace(os.getPrintWriter());
                } else {
                    this.printMessage(os, message, record.getParameters());
                }
                if (this._isNullDelimited) {
                    os.write(0);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFlush() {
        try {
            WriteStream writeStream = this._os;
            synchronized (writeStream) {
                this._os.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        if (this._os == null || this._os.getPath() == null) {
            return super.hashCode();
        }
        return this._os.getPath().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StreamHandler handler = (StreamHandler)o;
        if (this._os == null || handler._os == null) {
            return false;
        }
        return this._os.getPath().equals(handler._os.getPath());
    }

    @Override
    public String toString() {
        if (this._os == null) {
            return "StreamHandler@" + System.identityHashCode(this) + "[]";
        }
        return "StreamHandler@" + System.identityHashCode(this) + "[" + this._os.getPath() + "]";
    }
}

