/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.AbstractRolloverLog;
import com.caucho.log.RotateStream;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import javax.annotation.PostConstruct;

public class RotateLog {
    private static final L10N L = new L10N(RotateLog.class);
    private Path _path;
    private String _pathFormat;
    private String _archiveFormat;
    private Period _rolloverPeriod;
    private Bytes _rolloverSize;
    private int _rolloverCount = -1;
    private RotateStream _rotateStream;
    private String _timestamp;

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public String getPathFormat() {
        return this._pathFormat;
    }

    public void setPathFormat(String path) {
        this._pathFormat = path;
    }

    public void setHref(Path path) {
        this.setPath(path);
    }

    public void setRolloverPeriod(Period period) {
        this._rolloverPeriod = period;
    }

    public void setRolloverSize(Bytes size) {
        this._rolloverSize = size;
    }

    public void setRolloverSizeBytes(long size) {
        this._rolloverSize = new Bytes(size);
    }

    public int getRolloverCount() {
        return this._rolloverCount;
    }

    public void setRolloverCount(int count) {
        this._rolloverCount = count;
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    public String getArchiveFormat() {
        return this._archiveFormat;
    }

    public void setArchiveFormat(String format) {
        this._archiveFormat = format;
    }

    public RotateStream getRotateStream() {
        return this._rotateStream;
    }

    public String getTagName() {
        return "rotate-log";
    }

    @PostConstruct
    public void init() throws ConfigException, IOException {
        if (this._path != null) {
            this._rotateStream = RotateStream.create(this._path);
        } else if (this._pathFormat != null) {
            this._rotateStream = RotateStream.create(this._pathFormat);
        } else {
            throw new ConfigException(L.l("`path' is a required attribute of <{0}>.  Each <{0}> must configure the destination stream.", (Object)this.getTagName()));
        }
        if (this._path != null && this._path.exists() && !this._path.canRead() && (this._rolloverPeriod != null || this._rolloverSize != null || this._archiveFormat != null)) {
            throw new ConfigException(L.l("log path '{0}' is not readable and therefore cannot be rotated.", (Object)this._path.getURL()));
        }
        AbstractRolloverLog rolloverLog = this._rotateStream.getRolloverLog();
        if (this._rolloverPeriod != null) {
            rolloverLog.setRolloverPeriod(this._rolloverPeriod);
        }
        if (this._rolloverSize != null) {
            rolloverLog.setRolloverSize(this._rolloverSize);
        }
        this._rotateStream.setMaxRolloverCount(this._rolloverCount);
        if (this._archiveFormat != null) {
            rolloverLog.setArchiveFormat(this._archiveFormat);
        }
        this._rotateStream.init();
    }
}

