/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.module.Artifact;
import com.caucho.loader.module.ArtifactDependency;
import com.caucho.loader.module.ArtifactResolver;
import java.util.ArrayList;
import java.util.Collections;

public class ArtifactRepository {
    private static final EnvironmentLocal<ArtifactRepository> _local = new EnvironmentLocal();
    private ArtifactRepository _parent;
    private EnvironmentClassLoader _loader;
    private ArrayList<ArtifactResolver> _resolverList = new ArrayList();

    private ArtifactRepository(EnvironmentClassLoader loader) {
        EnvironmentClassLoader parentLoader;
        this._loader = loader;
        if (loader != null && (parentLoader = Environment.getEnvironmentClassLoader(loader.getParent())) != null && parentLoader != loader) {
            this._parent = ArtifactRepository.create(parentLoader);
        }
    }

    public static ArtifactRepository create() {
        return ArtifactRepository.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactRepository create(ClassLoader loader) {
        EnvironmentLocal<ArtifactRepository> environmentLocal = _local;
        synchronized (environmentLocal) {
            ArtifactRepository repository = _local.getLevel(loader);
            if (repository == null) {
                ClassLoader parentLoader = null;
                if (loader != null) {
                    parentLoader = loader.getParent();
                }
                EnvironmentClassLoader envLoader = Environment.getEnvironmentClassLoader(parentLoader);
                repository = new ArtifactRepository(envLoader);
                _local.set(repository);
            }
            return repository;
        }
    }

    public static ArtifactRepository getCurrent() {
        return _local.get();
    }

    public void addResolver(ArtifactResolver resolver) {
        this._resolverList.add(resolver);
    }

    public ArrayList<Artifact> resolve(ArtifactDependency dependency) {
        ArrayList<ArtifactDependency> peers = new ArrayList<ArtifactDependency>();
        return this.resolve(dependency, peers);
    }

    public ArrayList<Artifact> resolve(ArtifactDependency dependency, ArtifactDependency[] peerDependencyList) {
        ArrayList<ArtifactDependency> peers = new ArrayList<ArtifactDependency>();
        for (ArtifactDependency peer : peerDependencyList) {
            peers.add(peer);
        }
        return this.resolve(dependency, peers);
    }

    public ArrayList<Artifact> resolve(ArtifactDependency dependency, ArrayList<ArtifactDependency> peerDependencyList) {
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        this.resolve(artifactList, dependency);
        ArrayList<ArtifactDependency> peerDeps = this.resolvePeer(dependency, peerDependencyList);
        ArrayList<Artifact> filteredArtifactList = new ArrayList<Artifact>();
        for (Artifact artifact : artifactList) {
            if (!this.isValid(artifact, peerDeps)) continue;
            filteredArtifactList.add(artifact);
        }
        if (filteredArtifactList.size() > 0) {
            artifactList = filteredArtifactList;
        }
        Collections.sort(artifactList);
        Collections.reverse(artifactList);
        return artifactList;
    }

    private boolean isValid(Artifact artifact, ArrayList<ArtifactDependency> dependencyList) {
        for (ArtifactDependency dep : dependencyList) {
            if (artifact.isMatch(dep)) continue;
            return false;
        }
        return true;
    }

    protected void resolve(ArrayList<Artifact> artifactList, ArtifactDependency dependency) {
        if (this._parent != null) {
            this._parent.resolve(artifactList, dependency);
        }
        for (ArtifactResolver resolver : this._resolverList) {
            resolver.resolve(artifactList, dependency);
        }
    }

    protected ArrayList<ArtifactDependency> resolvePeer(ArtifactDependency dependency, ArrayList<ArtifactDependency> peerList) {
        ArrayList<ArtifactDependency> commonDeps = new ArrayList<ArtifactDependency>();
        for (ArtifactDependency peer : peerList) {
            if (peer == dependency) continue;
            ArrayList<Artifact> peerArtifacts = this.resolve(peer);
            for (Artifact peerArtifact : peerArtifacts) {
                for (ArtifactDependency peerDependency : peerArtifact.getDependencies()) {
                    if (!peerDependency.isSameArtifact(dependency)) continue;
                    commonDeps.add(peerDependency);
                }
            }
        }
        return commonDeps;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }
}

