/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.ivy;

import com.caucho.config.ConfigException;
import com.caucho.loader.ivy.IvyDependency;
import com.caucho.loader.ivy.IvyManager;
import com.caucho.loader.ivy.IvyModule;
import com.caucho.loader.ivy.IvyPattern;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class IvyCache {
    private static final Logger log = Logger.getLogger(IvyCache.class.getName());
    private static final String IVY_PATTERN = "[organisation]/[module]/ivy-[revision].xml";
    private static final String ARTIFACT_PATTERN = "[organisation]/[module]/[type]s/[artifact]-[revision].[ext]";
    private final IvyManager _manager;
    private Path _defaultCacheDir;
    private Path _repositoryCacheDir;
    private IvyPattern _artifactPattern;
    private IvyPattern _ivyPattern;

    IvyCache(IvyManager manager) {
        this._manager = manager;
    }

    public void setDefaultCacheDir(Path dir) {
        this._defaultCacheDir = dir;
    }

    public Path resolve(IvyDependency dependency) {
        return this.resolve(dependency, dependency.getRev());
    }

    public Path resolve(IvyDependency dependency, String rev) {
        String org = dependency.getOrg();
        String name = dependency.getName();
        String artifact = dependency.getArtifact();
        if (artifact == null) {
            artifact = name;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("organisation", org);
        props.put("module", name);
        props.put("artifact", artifact);
        props.put("revision", rev);
        props.put("type", "jar");
        props.put("ext", "jar");
        String pathName = this._artifactPattern.resolve(props);
        Path path = this._repositoryCacheDir.lookup(pathName);
        if (path.canRead()) {
            return path;
        }
        return null;
    }

    public IvyModule resolveIvy(IvyDependency dependency) {
        String org = dependency.getOrg();
        String name = dependency.getName();
        String artifact = dependency.getArtifact();
        String rev = dependency.getRev();
        if (artifact == null) {
            artifact = name;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("organisation", org);
        props.put("module", name);
        props.put("artifact", artifact);
        if (rev != null) {
            props.put("revision", rev);
        }
        props.put("type", "ivy");
        props.put("ext", "xml");
        String pathName = this._ivyPattern.resolve(props);
        Path path = this._repositoryCacheDir.lookup(pathName);
        if (path.canRead()) {
            return this._manager.configureIvyFile(path);
        }
        return null;
    }

    public void resolveVersions(ArrayList<String> versions, IvyDependency dependency) {
        String segment;
        int head;
        String org = dependency.getOrg();
        String name = dependency.getName();
        String artifact = dependency.getArtifact();
        String rev = dependency.getRev();
        if (artifact == null) {
            artifact = name;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("organisation", org);
        props.put("module", name);
        props.put("artifact", artifact);
        if (rev != null) {
            props.put("revision", rev);
        }
        props.put("type", "ivy");
        props.put("ext", "xml");
        String pathName = this._ivyPattern.resolveRevisionPath(props);
        int revIndex = pathName.indexOf("[revision]");
        if (revIndex < 0) {
            return;
        }
        int tail = pathName.indexOf(47, revIndex);
        if (tail > 0) {
            pathName = pathName.substring(0, tail);
        }
        if ((head = pathName.lastIndexOf(47)) > 0) {
            segment = pathName.substring(head + 1);
            pathName = pathName.substring(0, head);
        } else {
            segment = pathName = ".";
        }
        revIndex = segment.indexOf("[revision]");
        String prefix = segment.substring(0, revIndex);
        String suffix = segment.substring(revIndex + "[revision]".length());
        Path path = this._repositoryCacheDir.lookup(pathName);
        try {
            for (String item : path.list()) {
                if (!item.startsWith(prefix) || !item.endsWith(suffix)) continue;
                int len = item.length() - suffix.length();
                String revName = item.substring(prefix.length(), len);
                if (versions.contains(revName)) continue;
                versions.add(revName);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @PostConstruct
    public void init() {
        if (this._defaultCacheDir == null) {
            Path userDir = Vfs.lookup(System.getProperty("user.home"));
            this._defaultCacheDir = userDir.lookup(".ivy2/cache");
            log.fine("ivy-loader using " + this._defaultCacheDir);
        }
        if (this._repositoryCacheDir == null) {
            this._repositoryCacheDir = this._defaultCacheDir;
        }
        if (this._artifactPattern == null) {
            this._artifactPattern = new IvyPattern(ARTIFACT_PATTERN);
        }
        if (this._ivyPattern == null) {
            this._ivyPattern = new IvyPattern(IVY_PATTERN);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._defaultCacheDir + "]";
    }
}

