/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeakStopListener
implements EnvironmentListener {
    private static final L10N L = new L10N(WeakStopListener.class);
    private static final Logger log = Logger.getLogger(WeakStopListener.class.getName());
    private WeakReference<Object> _resourceRef;

    public WeakStopListener(Object resource) {
        this._resourceRef = new WeakReference<Object>(resource);
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        Object resource = this._resourceRef.get();
        if (resource == null) {
            return;
        }
        Method destroy = WeakStopListener.getStopMethod(resource.getClass());
        if (destroy == null) {
            return;
        }
        try {
            destroy.invoke(resource, (Object[])null);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public static Method getStopMethod(Class cl) {
        try {
            return cl.getMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

