/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.EnvironmentLocal;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EnvironmentProperties
extends Properties {
    private static Properties _origSystemProperties;
    private static Properties _envSystemProperties;
    private transient EnvironmentLocal<Properties> _envProps = new EnvironmentLocal();
    private Properties _global;

    public EnvironmentProperties(Properties global) {
        this._global = global;
    }

    public EnvironmentProperties() {
        this(new Properties());
    }

    public static void enableEnvironmentSystemProperties(boolean isEnable) {
        if (_origSystemProperties == null) {
            _origSystemProperties = System.getProperties();
            _envSystemProperties = new EnvironmentProperties(_origSystemProperties);
        }
        if (isEnable) {
            System.setProperties(_envSystemProperties);
        } else {
            System.setProperties(_origSystemProperties);
        }
    }

    public Properties getGlobalProperties() {
        return this._global;
    }

    public void setGlobalProperties(Properties global) {
        this._global = global;
    }

    @Override
    public int size() {
        return this.getEnvironmentProperties().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getEnvironmentProperties().isEmpty();
    }

    @Override
    public Enumeration keys() {
        return this.getEnvironmentProperties().keys();
    }

    @Override
    public Enumeration elements() {
        return this.getEnvironmentProperties().elements();
    }

    @Override
    public boolean contains(Object value) {
        return this.getEnvironmentProperties().contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getEnvironmentProperties().containsValue(value);
    }

    @Override
    public boolean containsKey(Object value) {
        return this.getEnvironmentProperties().containsKey(value);
    }

    public Object get(String key) {
        Properties props = this.getEnvironmentProperties();
        String value = props.getProperty(key);
        if (value != null) {
            return value;
        }
        return this._global.get(key);
    }

    @Override
    public Object get(Object key) {
        return this.get((String)key);
    }

    @Override
    public String getProperty(String key) {
        Properties props = this.getEnvironmentProperties();
        String value = props.getProperty(key);
        if (value != null) {
            return value;
        }
        return this._global.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        Properties props = this.getEnvironmentProperties();
        String value = props.getProperty(key);
        if (value != null) {
            return value;
        }
        return this._global.getProperty(key, defaultValue);
    }

    public Enumeration propertyNames() {
        return this.getEnvironmentProperties().propertyNames();
    }

    @Override
    public String put(String key, String value) {
        return (String)this.getPutEnvironmentProperties().put(key, value);
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.getPutEnvironmentProperties().put(key, value);
    }

    @Override
    public String remove(Object key) {
        return (String)this.getPutEnvironmentProperties().remove(key);
    }

    @Override
    public void clear() {
        this.getPutEnvironmentProperties().clear();
    }

    @Override
    public Object clone() {
        return this.getEnvironmentProperties().clone();
    }

    @Override
    public String toString() {
        return this.getEnvironmentProperties().toString();
    }

    @Override
    public Set keySet() {
        return this.getPutEnvironmentProperties().keySet();
    }

    @Override
    public Set entrySet() {
        return this.getPutEnvironmentProperties().entrySet();
    }

    @Override
    public Collection values() {
        return this.getPutEnvironmentProperties().values();
    }

    @Override
    public boolean equals(Object o) {
        return this.getEnvironmentProperties().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getEnvironmentProperties().hashCode();
    }

    private Properties getEnvironmentProperties() {
        Properties props = this._envProps.get();
        if (props != null) {
            return props;
        }
        return this._global;
    }

    private synchronized Properties getPutEnvironmentProperties() {
        Properties props = this._envProps.getLevel();
        if (props == null) {
            props = new Properties();
            Properties parentProps = this._envProps.get();
            if (parentProps == null) {
                parentProps = this._global;
            }
            props.putAll((Map<?, ?>)parentProps);
            this._envProps.set(props);
            return props;
        }
        return props;
    }

    public Object writeReplace() throws ObjectStreamException {
        return this.getEnvironmentProperties();
    }
}

