/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.SourceDebugExtensionAttribute;
import com.caucho.config.ConfigException;
import com.caucho.env.thread.ThreadPool;
import com.caucho.i18n.CharacterEncoding;
import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.EclipseCompiler;
import com.caucho.java.ExternalCompiler;
import com.caucho.java.GroovyCompiler;
import com.caucho.java.InternalCompiler;
import com.caucho.java.InternalCompiler2;
import com.caucho.java.InternalCompilerTools;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavacConfig;
import com.caucho.java.LineMap;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.make.Make;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JavaCompilerUtil {
    static final L10N L = new L10N(JavaCompilerUtil.class);
    static final Logger log = Logger.getLogger(JavaCompilerUtil.class.getName());
    private static final Object LOCK = new Object();
    private ClassLoader _loader;
    private String _compiler;
    private String _sourceExt = ".java";
    private Path _classDir;
    private Path _sourceDir;
    private boolean _compileParent = true;
    private String _extraClassPath;
    private String _classPath;
    protected String _charEncoding;
    protected ArrayList<String> _args;
    private int _maxBatch = 64;
    private long _startTimeout = 10000L;
    private long _maxCompileTime = 120000L;

    private JavaCompilerUtil() {
        String encoding = CharacterEncoding.getLocalEncoding();
        String javaEncoding = Encoding.getJavaName(encoding);
        if (javaEncoding == null || javaEncoding.equals("ISO8859_1")) {
            javaEncoding = null;
        }
        this._charEncoding = javaEncoding;
    }

    public static JavaCompilerUtil create() {
        return JavaCompilerUtil.create(Thread.currentThread().getContextClassLoader());
    }

    public static JavaCompilerUtil create(ClassLoader loader) {
        JavacConfig config = JavacConfig.getLocalConfig();
        String javac = config.getCompiler();
        JavaCompilerUtil javaCompiler = new JavaCompilerUtil();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        javaCompiler.setClassLoader(loader);
        javaCompiler.setCompiler(javac);
        javaCompiler.setArgs(config.getArgs());
        javaCompiler.setEncoding(config.getEncoding());
        javaCompiler.setMaxBatch(config.getMaxBatch());
        javaCompiler.setStartTimeout(config.getStartTimeout());
        javaCompiler.setMaxCompileTime(config.getMaxCompileTime());
        return javaCompiler;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setCompiler(String compiler) {
        this._compiler = compiler;
    }

    public String getCompiler() {
        if (this._compiler == null) {
            this._compiler = "javac";
        }
        return this._compiler;
    }

    public void setClassDir(Path path) {
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._classDir = path;
    }

    Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        return CauchoSystem.getWorkPath();
    }

    String getClassDirName() {
        return this.getClassDir().getNativePath();
    }

    public void setSourceDir(Path path) {
        this._sourceDir = path;
    }

    public Path getSourceDir() {
        if (this._sourceDir != null) {
            return this._sourceDir;
        }
        return this.getClassDir();
    }

    String getSourceDirName() {
        return this.getSourceDir().getNativePath();
    }

    public void setSourceExtension(String ext) {
        this._sourceExt = ext;
    }

    public String getSourceExtension() {
        return this._sourceExt;
    }

    public void setClassPath(String classPath) {
        this._classPath = classPath;
    }

    public void setExtraClassPath(String classPath) {
        this._extraClassPath = classPath;
    }

    public void setCompileParent(boolean compileParent) {
        this._compileParent = compileParent;
    }

    public String getClassPath() {
        String rawClassPath = this.buildClassPath();
        return rawClassPath;
    }

    private String buildClassPath() {
        String classPath = null;
        if (classPath != null) {
            return classPath;
        }
        if (classPath == null && this._loader instanceof DynamicClassLoader) {
            classPath = ((DynamicClassLoader)this._loader).getClassPath();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(CauchoSystem.getClassPath());
            if (this._loader != null) {
                JavaCompilerUtil.buildClassPath(sb, this._loader);
            }
            classPath = sb.toString();
        }
        String srcDirName = this.getSourceDirName();
        String classDirName = this.getClassDirName();
        char sep = CauchoSystem.getPathSeparatorChar();
        if (this._extraClassPath != null) {
            classPath = classPath + sep + this._extraClassPath;
        }
        if (!srcDirName.equals(classDirName)) {
            classPath = srcDirName + sep + classPath;
        }
        classPath = classDirName + sep + classPath;
        return classPath;
    }

    private static void buildClassPath(StringBuilder sb, ClassLoader loader) {
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            JavaCompilerUtil.buildClassPath(sb, parent);
        }
        if (loader instanceof DynamicClassLoader) {
            DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
            sb.append(dynLoader.getClassPath());
            return;
        }
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                String urlString;
                if (sb.length() > 0) {
                    sb.append(CauchoSystem.getPathSeparatorChar());
                }
                if ((urlString = url.toString()).startsWith("file:")) {
                    urlString = urlString.substring("file:".length());
                }
                if (Path.isWindows() && urlString.contains("%20")) {
                    urlString = urlString.replace("%20", " ");
                }
                sb.append(urlString);
            }
        }
    }

    public void setArgs(String argString) {
        try {
            if (argString != null) {
                String[] args = Pattern.compile("[\\s,]+").split(argString);
                this._args = new ArrayList();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("")) continue;
                    this._args.add(args[i]);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public ArrayList<String> getArgs() {
        return this._args;
    }

    public void setEncoding(String encoding) {
        this._charEncoding = encoding;
        String javaEncoding = Encoding.getJavaName(encoding);
        if ("ISO8859_1".equals(javaEncoding)) {
            this._charEncoding = null;
        }
    }

    public String getEncoding() {
        return this._charEncoding;
    }

    public long getStartTimeout() {
        return this._startTimeout;
    }

    public void setStartTimeout(long startTimeout) {
        this._startTimeout = startTimeout;
    }

    public long getMaxCompileTime() {
        return this._maxCompileTime;
    }

    public void setMaxCompileTime(long maxCompileTime) {
        this._maxCompileTime = maxCompileTime;
    }

    public void setMaxBatch(int maxBatch) {
        this._maxBatch = maxBatch;
    }

    public static String mangleName(String name) {
        int p = name.toLowerCase().indexOf("web-inf");
        if (p >= 0) {
            int len = "web-inf".length();
            name = name.substring(0, p) + "web-inf" + name.substring(p + len);
        }
        boolean toLower = CauchoSystem.isCaseInsensitive();
        CharBuffer cb = new CharBuffer();
        cb.append("_");
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '/' || ch == CauchoSystem.getPathSeparatorChar()) {
                if (i == 0 || cb.charAt(cb.length() - 1) == '.' || i + 1 >= name.length() || name.charAt(i + 1) == '/') continue;
                cb.append("._");
                continue;
            }
            if (ch == '.') {
                cb.append("__");
                continue;
            }
            if (ch == '_') {
                cb.append("_0");
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(toLower ? Character.toLowerCase(ch) : ch);
                continue;
            }
            if (ch <= '\u0100') {
                cb.append("_2" + JavaCompilerUtil.encodeHex(ch >> 4) + JavaCompilerUtil.encodeHex(ch));
                continue;
            }
            cb.append("_4" + JavaCompilerUtil.encodeHex(ch >> 12) + JavaCompilerUtil.encodeHex(ch >> 8) + JavaCompilerUtil.encodeHex(ch >> 4) + JavaCompilerUtil.encodeHex(ch));
        }
        if (cb.length() == 0) {
            cb.append("_z");
        }
        return cb.toString();
    }

    private static char encodeHex(int i) {
        if ((i &= 0xF) < 10) {
            return (char)(i + 48);
        }
        return (char)(i - 10 + 97);
    }

    public void setArgs(ArrayList<String> args) {
        if (args == null) {
            return;
        }
        if (this._args == null) {
            this._args = new ArrayList();
        }
        this._args.addAll(args);
    }

    public void compile(String fileName, LineMap lineMap) throws IOException, ClassNotFoundException {
        this.compile(fileName, lineMap, false);
    }

    public void compileIfModified(String fileName, LineMap lineMap) throws IOException, ClassNotFoundException {
        this.compile(fileName, lineMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String fileName, LineMap lineMap, boolean ifModified) throws IOException, ClassNotFoundException {
        if (this._compileParent) {
            try {
                if (this._loader instanceof Make) {
                    ((Make)((Object)this._loader)).make();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        int p = fileName.lastIndexOf(46);
        String path = fileName.substring(0, p);
        String javaName = path + this._sourceExt;
        Path javaPath = this.getSourceDir().lookup(javaName);
        String className = path + ".class";
        Path classPath = this.getClassDir().lookup(className);
        Object object = LOCK;
        synchronized (object) {
            if (ifModified && javaPath.getLastModified() <= classPath.getLastModified()) {
                return;
            }
            if (javaPath.canRead() && classPath.exists()) {
                classPath.remove();
            }
            this.compileInt(new String[]{fileName}, lineMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileBatch(String[] files) throws IOException, ClassNotFoundException {
        if (this._compileParent) {
            try {
                if (this._loader instanceof Make) {
                    ((Make)((Object)this._loader)).make();
                }
            }
            catch (Exception e) {
                throw new IOExceptionWrapper(e);
            }
        }
        if (files.length == 0) {
            return;
        }
        int batchCount = this._maxBatch;
        if (batchCount < 0) {
            batchCount = 0x3FFFFFFF;
        } else if (batchCount == 0) {
            batchCount = 1;
        }
        IOException exn = null;
        ArrayList<String> uniqueFiles = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (uniqueFiles.contains(files[i])) continue;
            uniqueFiles.add(files[i]);
        }
        files = new String[uniqueFiles.size()];
        uniqueFiles.toArray(files);
        Object object = LOCK;
        synchronized (object) {
            for (int i = 0; i < files.length; i += batchCount) {
                int len = files.length - i;
                if (batchCount < len) {
                    len = batchCount;
                }
                Object[] batchFiles = new String[len];
                System.arraycopy(files, i, batchFiles, 0, len);
                Arrays.sort(batchFiles);
                try {
                    this.compileInt((String[])batchFiles, null);
                    continue;
                }
                catch (IOException e) {
                    if (exn == null) {
                        exn = e;
                        continue;
                    }
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        if (exn != null) {
            throw exn;
        }
    }

    protected void compileInt(String[] path, LineMap lineMap) throws IOException, JavaCompileException {
        Throwable exn;
        for (int i = 0; i < path.length; ++i) {
            log.config("Compiling " + path[i]);
        }
        AbstractJavaCompiler compiler = this._compiler.equals("internal") ? new InternalCompiler(this) : (this._compiler.equals("internal2") ? new InternalCompiler2(this) : (this._compiler.equals("tools") ? new InternalCompilerTools(this) : (this._compiler.equals("eclipse") ? new EclipseCompiler(this) : (this._compiler.equals("groovyc") ? new GroovyCompiler(this) : new ExternalCompiler(this)))));
        compiler.setPath(path);
        compiler.setLineMap(lineMap);
        ThreadPool.getCurrent().start(compiler, this._startTimeout);
        compiler.waitForComplete(this.getMaxCompileTime());
        if (!compiler.isDone()) {
            log.warning("compilation timed out");
            compiler.abort();
        }
        if ((exn = compiler.getException()) != null) {
            if (exn instanceof IOException) {
                throw (IOException)exn;
            }
            if (exn instanceof JavaCompileException) {
                throw (JavaCompileException)exn;
            }
            if (exn instanceof RuntimeException) {
                throw (RuntimeException)exn;
            }
            if (exn instanceof Error) {
                throw (Error)exn;
            }
            throw new IOExceptionWrapper(exn);
        }
        for (int i = 0; i < path.length; ++i) {
            Path javaPath = this.getSourceDir().lookup(path[i]);
            if (!path[i].endsWith(".java")) continue;
            String className = path[i].substring(0, path[i].length() - 5) + ".class";
            Path classPath = this.getClassDir().lookup(className);
            Path smapPath = this.getSourceDir().lookup(path[i] + ".smap");
            if (!classPath.canRead() || !smapPath.canRead()) continue;
            this.mergeSmap(classPath, smapPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeSmap(Path classPath, Path smapPath) {
        try {
            JavaClass javaClass;
            if (smapPath.getLength() >= 65536L) {
                log.warning(".smap for " + classPath.getTail() + " is too large (" + smapPath.getLength() + " bytes)");
                return;
            }
            log.fine("merging .smap for " + classPath.getTail());
            ByteCodeParser parser = new ByteCodeParser();
            ReadStream is = classPath.openRead();
            try {
                javaClass = parser.parse(is);
            }
            finally {
                is.close();
            }
            CharBuffer smap = new CharBuffer();
            is = smapPath.openRead();
            try {
                int ch;
                while ((ch = is.read()) >= 0) {
                    smap.append((char)ch);
                }
            }
            finally {
                is.close();
            }
            SourceDebugExtensionAttribute attr = new SourceDebugExtensionAttribute(smap.toString());
            javaClass.addAttribute(attr);
            WriteStream os = classPath.openWrite();
            try {
                javaClass.write(os);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }
}

