/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread1;

import com.caucho.config.ConfigException;
import com.caucho.env.thread1.AbstractTaskWorker1;
import com.caucho.inject.Module;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

@Module
public abstract class AbstractThreadLauncher1
extends AbstractTaskWorker1 {
    private static final L10N L = new L10N(AbstractThreadLauncher1.class);
    private static final Logger log = Logger.getLogger(AbstractThreadLauncher1.class.getName());
    private static final long LAUNCHER_TIMEOUT = 60000L;
    private static final int DEFAULT_THREAD_MAX = 8192;
    private static final int DEFAULT_IDLE_MIN = 2;
    private static final int DEFAULT_IDLE_MAX = 0x3FFFFFFF;
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private int _threadMax = 8192;
    private int _idleMin = 2;
    private int _idleMax = 0x3FFFFFFF;
    private long _idleTimeout = 60000L;
    private long _throttlePeriod = 1000L;
    private int _throttleLimit = 100;
    private long _throttleSleep = 0L;
    private final AtomicInteger _threadCount = new AtomicInteger();
    private final AtomicInteger _idleCount = new AtomicInteger();
    private final AtomicInteger _startingCount = new AtomicInteger();
    private final AtomicLong _createCountTotal = new AtomicLong();
    private final AtomicLong _threadIdleExpireTime = new AtomicLong();
    private long _throttleTimestamp;
    private long _throttleCount;
    private boolean _isThrottle;
    private final AtomicInteger _gId = new AtomicInteger();
    private final Lifecycle _lifecycle;

    protected AbstractThreadLauncher1() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected AbstractThreadLauncher1(ClassLoader loader) {
        super(loader);
        this.setWorkerIdleTimeout(60000L);
        this._lifecycle = new Lifecycle();
    }

    protected abstract void launchChildThread(int var1);

    public void setThreadMax(int max) {
        if (max < this._idleMin) {
            throw new ConfigException(L.l("IdleMin ({0}) must be less than ThreadMax ({1})", this._idleMin, max));
        }
        if (max < 1) {
            throw new ConfigException(L.l("ThreadMax ({0}) must be greater than zero", max));
        }
        this._threadMax = max;
        this.update();
    }

    public int getThreadMax() {
        return this._threadMax;
    }

    public void setIdleMin(int min) {
        if (this._threadMax < min) {
            throw new ConfigException(L.l("IdleMin ({0}) must be less than ThreadMax ({1})", min, this._threadMax));
        }
        if (min <= 0) {
            throw new ConfigException(L.l("IdleMin ({0}) must be greater than 0.", min));
        }
        this._idleMin = min;
        this.update();
    }

    public int getIdleMin() {
        return this._idleMin;
    }

    public void setIdleMax(int max) {
        if (this._threadMax < max) {
            throw new ConfigException(L.l("IdleMax ({0}) must be less than ThreadMax ({1})", max, this._threadMax));
        }
        if (max <= 0) {
            throw new ConfigException(L.l("IdleMax ({0}) must be greater than 0.", max));
        }
        this._idleMax = max;
        this.update();
    }

    public int getIdleMax() {
        return this._idleMax;
    }

    public void setIdleTimeout(long timeout) {
        this._idleTimeout = timeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    protected boolean isEnable() {
        return this._lifecycle.isActive();
    }

    public void setThrottlePeriod(long period) {
        this._throttlePeriod = period;
    }

    public void setThrottleLimit(int limit) {
        this._throttleLimit = limit;
    }

    public void setThrottleSleepTime(long period) {
        this._throttleSleep = period;
    }

    public void start() {
        this._lifecycle.toActive();
        this.wake();
    }

    @Override
    public void destroy() {
        super.destroy();
        this._lifecycle.toDestroy();
    }

    public boolean isThreadMax() {
        return this._threadMax <= this._threadCount.get() && this._startingCount.get() == 0;
    }

    public void onChildThreadBegin() {
        this._threadCount.incrementAndGet();
        int startCount = this._startingCount.decrementAndGet();
        if (startCount < 0) {
            this._startingCount.set(0);
            new IllegalStateException().printStackTrace();
        }
        this._createCountTotal.incrementAndGet();
    }

    public void onChildThreadResume() {
        this._threadCount.incrementAndGet();
    }

    public void onChildThreadEnd() {
        if (this._threadMax <= this._threadCount.getAndDecrement()) {
            this.wake();
        }
        if (this._idleCount.get() <= this._idleMin) {
            this.wake();
        }
    }

    public boolean isIdleExpire() {
        if (!this._lifecycle.isActive()) {
            return true;
        }
        long now = this.getCurrentTimeActual();
        long idleExpire = this._threadIdleExpireTime.get();
        int idleCount = this._idleCount.get();
        if (this._idleMin < idleCount) {
            long nextIdleExpire = now + this._idleTimeout;
            if (this._idleMax < idleCount && this._idleMin < this._idleMax) {
                this._threadIdleExpireTime.compareAndSet(idleExpire, nextIdleExpire);
                return true;
            }
            if (idleExpire < now && this._threadIdleExpireTime.compareAndSet(idleExpire, nextIdleExpire)) {
                return true;
            }
        }
        return false;
    }

    public boolean childIdleBegin() {
        int idleCount;
        do {
            idleCount = this._idleCount.get();
            if (!this.isIdleExpire()) continue;
            return false;
        } while (!this._idleCount.compareAndSet(idleCount, idleCount + 1));
        return true;
    }

    public void onChildIdleBegin() {
        this._idleCount.incrementAndGet();
    }

    public void onChildIdleEnd() {
        int idleCount = this._idleCount.decrementAndGet();
        if (idleCount <= this._idleMin) {
            this.updateIdleExpireTime(this.getCurrentTimeActual());
            this.wake();
        }
    }

    protected void updateIdleExpireTime(long now) {
        this._threadIdleExpireTime.set(now + this._idleTimeout);
    }

    protected boolean doStart() {
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (!this.isEnable()) {
            return false;
        }
        int startingCount = this._startingCount.getAndIncrement();
        int threadCount = this._threadCount.get() + startingCount;
        if (this._threadMax < threadCount) {
            this._startingCount.decrementAndGet();
            this.onThreadMax();
            return false;
        }
        if (this.isIdleTooLow(startingCount)) {
            return true;
        }
        this._startingCount.decrementAndGet();
        return false;
    }

    private void onStartFail() {
        this._startingCount.getAndDecrement();
    }

    protected boolean isIdleTooLow(int startingCount) {
        return this._idleCount.get() + startingCount <= this._idleMin;
    }

    @Override
    protected boolean isPermanent() {
        return true;
    }

    protected void update() {
        long now = this.getCurrentTimeActual();
        this._threadIdleExpireTime.set(now + this._idleTimeout);
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnection() {
        while (this.doStart()) {
            boolean isValid = false;
            try {
                long now = this.getCurrentTimeActual();
                this.updateIdleExpireTime(now);
                int id = this._gId.incrementAndGet();
                this.updateThrottle();
                this.launchChildThread(id);
                isValid = true;
            }
            finally {
                if (isValid) continue;
                this.onStartFail();
            }
        }
    }

    protected void updateThrottle() {
        long now = CurrentTime.getCurrentTimeActual();
        if (this._throttleTimestamp + this._throttlePeriod < now) {
            this._throttleTimestamp = now;
            this._throttleCount = 1L;
            this._isThrottle = false;
            return;
        }
        ++this._throttleCount;
        if (this._throttleCount < (long)this._throttleLimit) {
            return;
        }
        System.out.println("THROTTLE: " + this._throttleCount + " " + this);
        if (!this._isThrottle) {
            this._isThrottle = true;
            String msg = this + " " + this._throttleCount + " threads created in " + this._throttlePeriod + "ms sleep=" + this._throttleSleep + "ms";
            this.onThrottle(msg);
        }
        if (this._throttleSleep > 0L) {
            try {
                Thread.sleep(this._throttleSleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void onThreadMax() {
    }

    protected void onThrottle(String msg) {
        log.warning(msg);
    }

    public int getThreadCount() {
        return this._threadCount.get();
    }

    public int getIdleCount() {
        return this._idleCount.get();
    }

    public int getStartingCount() {
        return this._startingCount.get();
    }

    public long getCreateCountTotal() {
        return this._createCountTotal.get();
    }

    @Override
    public long runTask() {
        this.startConnection();
        return -1L;
    }
}

