/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.env.meter.JmxCalculationMeterImpl;
import com.caucho.jmx.Jmx;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class JmxExpr {
    private static final L10N L = new L10N(JmxCalculationMeterImpl.class);
    private static final Logger log = Logger.getLogger(JmxCalculationMeterImpl.class.getName());

    protected abstract void sample();

    protected abstract double calculate();

    public static class JmxAdd
    extends JmxContainerExpr {
        @Override
        public double calculate() {
            ArrayList<JmxExpr> children = this.getChildren();
            int size = children.size();
            double total = 0.0;
            for (int i = 0; i < size; ++i) {
                total += children.get(i).calculate();
            }
            return total;
        }
    }

    public static class JmxRatio
    extends JmxContainerExpr {
        @Override
        public double calculate() {
            ArrayList<JmxExpr> children = this.getChildren();
            int size = children.size();
            double total = 0.0;
            for (int i = 1; i < size; ++i) {
                total += children.get(i).calculate();
            }
            if (total == 0.0 || size == 0) {
                return 0.0;
            }
            JmxExpr firstChild = children.get(0);
            return firstChild.calculate() / total;
        }
    }

    public static class JmxRate
    extends JmxContainerExpr {
        @Override
        public double calculate() {
            ArrayList<JmxExpr> children = this.getChildren();
            int size = children.size();
            double total = 0.0;
            for (int i = 0; i < size; ++i) {
                total += children.get(i).calculate();
            }
            if (total == 0.0) {
                return 0.0;
            }
            JmxExpr firstChild = children.get(0);
            return firstChild.calculate() / total;
        }
    }

    public static class JmxDelta
    extends JmxExpr {
        private MBeanServer _server = Jmx.getGlobalMBeanServer();
        private ObjectName _objectName;
        private String _attribute;
        private boolean _isOptional;
        private double _prevSample;
        private double _lastSample;

        public void setObjectName(String name) {
            try {
                this._objectName = Jmx.getObjectName(name);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }

        public void setAttribute(String name) {
            this._attribute = name;
        }

        public boolean isOptional() {
            return this._isOptional;
        }

        @Configurable
        public void setOptional(boolean optional) {
            this._isOptional = optional;
        }

        @PostConstruct
        public void init() {
            if (this._objectName == null) {
                throw new ConfigException(L.l("objectName is required for JMX <value>"));
            }
            if (this._attribute == null) {
                throw new ConfigException(L.l("attribute is required for JMX <value>"));
            }
        }

        @Override
        protected void sample() {
            try {
                this._prevSample = this._lastSample;
                Object value = this._server.getAttribute(this._objectName, this._attribute);
                if (value == null) {
                    this._lastSample = 0.0;
                    return;
                }
                this._lastSample = ((Number)value).doubleValue();
            }
            catch (Exception e) {
                if (this.isOptional() && e instanceof InstanceNotFoundException) {
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.log(Level.FINE, e.toString(), e);
                }
                this._lastSample = 0.0;
            }
        }

        @Override
        public double calculate() {
            return this._lastSample - this._prevSample;
        }
    }

    public static class JmxValue
    extends JmxExpr {
        private MBeanServer _server = Jmx.getGlobalMBeanServer();
        private ObjectName _objectName;
        private String _attribute;
        private double _lastSample;

        public void setObjectName(String name) {
            try {
                this._objectName = Jmx.getObjectName(name);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }

        public void setAttribute(String name) {
            this._attribute = name;
        }

        @PostConstruct
        public void init() {
            if (this._objectName == null) {
                throw new ConfigException(L.l("objectName is required for JMX <value>"));
            }
            if (this._attribute == null) {
                throw new ConfigException(L.l("attribute is required for JMX <value>"));
            }
        }

        @Override
        protected void sample() {
            try {
                Object value = this._server.getAttribute(this._objectName, this._attribute);
                if (value == null) {
                    this._lastSample = 0.0;
                    return;
                }
                this._lastSample = ((Number)value).doubleValue();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                this._lastSample = 0.0;
            }
        }

        @Override
        public double calculate() {
            return this._lastSample;
        }
    }

    protected static abstract class JmxContainerExpr
    extends JmxExpr {
        private ArrayList<JmxExpr> _children = new ArrayList();

        protected JmxContainerExpr() {
        }

        public void addValue(JmxValue value) {
            this.add(value);
        }

        public void addDelta(JmxDelta value) {
            this.add(value);
        }

        public void addRate(JmxRate expr) {
            this.add(expr);
        }

        public void addRatio(JmxRatio expr) {
            this.add(expr);
        }

        public void addAdd(JmxAdd expr) {
            this.add(expr);
        }

        public void add(JmxExpr expr) {
            this._children.add(expr);
        }

        protected ArrayList<JmxExpr> getChildren() {
            return this._children;
        }

        @Override
        protected void sample() {
            int size = this._children.size();
            for (int i = 0; i < size; ++i) {
                this._children.get(i).sample();
            }
        }
    }
}

