/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor.ActorQueue;
import com.caucho.env.actor.ActorQueueApi;
import com.caucho.util.RingItem;
import com.caucho.util.RingItemFactory;

public class ValueActorQueue<T>
implements ActorQueueApi<T> {
    private final ActorQueue<ValueItem<T>> _actorQueue;

    public ValueActorQueue(int capacity, ActorProcessor<? super T> ... processors) {
        if (processors == null) {
            throw new NullPointerException();
        }
        ActorProcessor[] valueProcessors = new ActorProcessor[processors.length];
        for (int i = 0; i < processors.length; ++i) {
            valueProcessors[i] = new ValueItemProcessor<T>(processors[i]);
        }
        this._actorQueue = new ActorQueue(capacity, new ValueItemFactory(), valueProcessors);
    }

    @Override
    public int getAvailable() {
        return this._actorQueue.getAvailable();
    }

    @Override
    public boolean isEmpty() {
        return this._actorQueue.isEmpty();
    }

    @Override
    public int getSize() {
        return this._actorQueue.getSize();
    }

    @Override
    public final void offer(T value) {
        ActorQueue<ValueItem<ValueItem<T>>> actorQueue = this._actorQueue;
        ValueItem<T> item = actorQueue.startOffer(true);
        item.init(value);
        actorQueue.finishOffer(item);
        this.wake();
    }

    @Override
    public final boolean offer(T value, boolean isWait) {
        ActorQueue<ValueItem<ValueItem<T>>> actorQueue = this._actorQueue;
        ValueItem<T> item = actorQueue.startOffer(isWait);
        if (item == null) {
            return false;
        }
        item.init(value);
        actorQueue.finishOffer(item);
        this.wake();
        return true;
    }

    public String getWorkerState() {
        return this._actorQueue.getWorkerState();
    }

    @Override
    public void wake() {
        this._actorQueue.wake();
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._actorQueue + "]";
    }

    private static final class ValueItemProcessor<T>
    extends AbstractActorProcessor<ValueItem<T>> {
        private final ActorProcessor<T> _processor;

        ValueItemProcessor(ActorProcessor<T> processor) {
            this._processor = processor;
        }

        @Override
        public String getThreadName() {
            return this._processor.getThreadName();
        }

        @Override
        public void process(ValueItem<T> item) throws Exception {
            T value = item.getAndClear();
            this._processor.process(value);
        }

        @Override
        public void onProcessComplete() throws Exception {
            this._processor.onProcessComplete();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._processor + "]";
        }
    }

    private static final class ValueItemFactory<T>
    implements RingItemFactory<ValueItem<T>> {
        private ValueItemFactory() {
        }

        @Override
        public ValueItem<T> createItem(int index) {
            return new ValueItem(index);
        }
    }

    private static final class ValueItem<T>
    extends RingItem {
        private T _value;

        ValueItem(int index) {
            super(index);
        }

        public void init(T value) {
            this._value = value;
        }

        public T getAndClear() {
            T value = this._value;
            this._value = null;
            return value;
        }
    }
}

