/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.config.types.Signature;
import com.caucho.el.ELParseException;
import com.caucho.el.Expr;
import com.caucho.el.Marshall;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;

public class StaticMethodExpr
extends Expr {
    private static final Object[] NULL_ARGS = new Object[0];
    private Method _method;
    private Marshall[] _marshall;
    private boolean _isVoid;

    public StaticMethodExpr(Method method) {
        this._method = method;
        this.initMethod();
    }

    public StaticMethodExpr(String signature) {
        try {
            Signature sig = new Signature();
            sig.addText(signature);
            sig.init();
            this._method = sig.getMethod();
            if (this._method == null) {
                throw new RuntimeException(L.l("'{0}' is an unknown method", (Object)sig));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initMethod();
    }

    private void initMethod() {
        Class<?>[] param = this._method.getParameterTypes();
        this._marshall = new Marshall[param.length];
        for (int i = 0; i < this._marshall.length; ++i) {
            this._marshall[i] = Marshall.create(param[i]);
        }
        this._isVoid = Void.TYPE.equals(this._method.getReturnType());
    }

    @Override
    public Object getValue(ELContext env) throws ELException {
        return this._method;
    }

    public Object evalMethod(Expr[] args, ELContext env) throws ELException {
        if (this._marshall.length != args.length) {
            throw new ELParseException(L.l("Arguments to '{0}' do not match expected length {1}.", (Object)this._method.getName(), this._marshall.length));
        }
        try {
            Object[] objs;
            if (args.length > 0) {
                objs = new Object[args.length];
                for (int i = 0; i < this._marshall.length; ++i) {
                    objs[i] = this._marshall[i].marshall(args[i], env);
                }
            } else {
                objs = NULL_ARGS;
            }
            if (!this._isVoid) {
                return this._method.invoke(null, objs);
            }
            this._method.invoke(null, objs);
            return null;
        }
        catch (ELException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new ELException(e.getCause());
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.StaticMethodExpr(\"");
        this.printType(os, this._method.getReturnType());
        os.print(" ");
        os.print(this._method.getDeclaringClass().getName());
        os.print(".");
        os.print(this._method.getName());
        os.print("(");
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this.printType(os, parameterTypes[i]);
        }
        os.print(")");
        os.print("\")");
    }

    private void printType(WriteStream os, Class<?> cl) throws IOException {
        if (cl.isArray()) {
            this.printType(os, cl.getComponentType());
            os.print("[]");
        } else {
            os.print(cl.getName());
        }
    }

    private Object writeReplace() {
        StringBuilder sig = new StringBuilder();
        this.addType(sig, this._method.getReturnType());
        sig.append(" ");
        sig.append(this._method.getDeclaringClass().getName());
        sig.append(".");
        sig.append(this._method.getName());
        sig.append("(");
        Class<?>[] param = this._method.getParameterTypes();
        for (int i = 0; i < param.length; ++i) {
            if (i != 0) {
                sig.append(",");
            }
            this.addType(sig, param[i]);
        }
        sig.append(")");
        return new Handle(sig.toString());
    }

    private void addType(StringBuilder sb, Class<?> cl) {
        if (cl.isArray()) {
            this.addType(sb, cl.getComponentType());
            sb.append("[]");
        } else {
            sb.append(cl.getName());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof StaticMethodExpr)) {
            return false;
        }
        StaticMethodExpr expr = (StaticMethodExpr)((Object)o);
        return this._method.equals(expr._method);
    }

    @Override
    public String toString() {
        return this._method.getName();
    }

    static class Handle
    implements Serializable {
        private String _signature;

        private Handle() {
        }

        private Handle(String signature) {
            this._signature = signature;
        }

        public Object readResolve() {
            return new StaticMethodExpr(this._signature);
        }
    }
}

