/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.io;

import com.caucho.db.io.InStore;
import com.caucho.db.io.OutStore;
import com.caucho.db.io.StoreBuilder;
import com.caucho.db.io.StoreReadWrite;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class StoreReadWriteImpl
implements StoreReadWrite {
    private static final Logger log = Logger.getLogger(StoreReadWriteImpl.class.getName());
    private static final L10N L = new L10N(StoreReadWriteImpl.class);
    private final Path _path;
    private long _fileSize;
    private final AtomicReference<RandomAccessStream> _cachedRead = new AtomicReference();
    private final AtomicReference<RandomAccessStream> _cachedWrite = new AtomicReference();
    private final AtomicBoolean _isClosed = new AtomicBoolean();

    StoreReadWriteImpl(StoreBuilder builder) {
        this._path = builder.getPath();
        this._fileSize = Math.max(this._path.getLength(), 0L);
    }

    @Override
    public long getFileSize() {
        return this._fileSize;
    }

    @Override
    public long getChunkSize() {
        return 65536L;
    }

    private void setFileSize(long size) {
        this._fileSize = Math.max(this._fileSize, size);
    }

    @Override
    public long getMmapCloseTimeout() {
        return 0L;
    }

    @Override
    public void create() throws IOException {
        this._path.getParent().mkdirs();
        if (this._path.exists()) {
            throw new IOException(L.l("CREATE for path '{0}' failed, because the file already exists.  CREATE can not override an existing table.", (Object)this._path.getNativePath()));
        }
        WriteStream os = null;
        try {
            os = this._path.openWrite();
        }
        finally {
            IoUtil.close(os);
        }
    }

    boolean isFileExist() {
        return this._path.exists();
    }

    @Override
    public void init() throws IOException {
        OutStore os = null;
        try {
            os = this.openWrite(0L, 0x800000);
            this.setFileSize(os.getLength());
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    @Override
    public InStore openRead(long offset, int size) {
        long addressMax = offset + (long)size;
        if (this.getFileSize() < addressMax) {
            throw new IllegalStateException(L.l("{0} read open for length {1} but file length {2}", (Object)this, (Object)addressMax, (Object)this.getFileSize()));
        }
        InStore is = null;
        try {
            is = this.openReadImpl(addressMax);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InStore openReadImpl(long fileSize) throws IOException {
        if (this._isClosed.get()) {
            throw new IllegalStateException(L.l("{0} is closed.", (Object)this));
        }
        RandomAccessStream is = this._cachedRead.getAndSet(null);
        while (is == null || !is.allocate()) {
            Path path = this._path;
            is = null;
            if (path != null) {
                is = this.streamOpen(fileSize);
            }
            if (is != null) continue;
            throw new IllegalStateException("Cannot open file");
        }
        return new StreamRead(is);
    }

    @Override
    public OutStore openWrite(long offset, int size) {
        long fileSize = offset + (long)size;
        try {
            if (this._isClosed.get()) {
                throw new IllegalStateException(L.l("{0} is closed.", (Object)this));
            }
            RandomAccessStream os = this._cachedWrite.getAndSet(null);
            while (os == null || !os.allocate()) {
                Path path = this._path;
                os = null;
                if (path != null) {
                    os = this.streamOpen(fileSize);
                }
                if (os != null) continue;
                throw new IllegalStateException("Cannot open file");
            }
            return new StreamWrite(os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RandomAccessStream streamOpen(long fileSize) throws IOException {
        if (this._isClosed.get()) {
            throw new IllegalStateException();
        }
        int retry = 8;
        RandomAccessStream s = this._path.openRandomAccess();
        if (this._fileSize < fileSize) {
            this.extendFile(s, fileSize);
        }
        return s;
    }

    private long extendFile(RandomAccessStream os, long addressMax) throws IOException {
        long fileSize = this._fileSize;
        if (addressMax <= fileSize) {
            return fileSize;
        }
        fileSize = this.extendFileSize(fileSize, this._fileSize);
        fileSize = Math.max(fileSize, this._path.getLength());
        os.write(fileSize - 1L, new byte[1], 0, 1);
        this.setFileSize(fileSize);
        return this._fileSize;
    }

    private long extendFileSize(long oldFileSize, long reqFileSize) {
        long newFileSize = 5L * oldFileSize / 4L + 0x800000L;
        long index = Long.highestOneBit(newFileSize);
        long mask = (index - 1L ^ 0xFFFFFFFFFFFFFFFFL) >> 3;
        return Math.max(newFileSize & mask, reqFileSize);
    }

    @Override
    public void fsync() {
    }

    @Override
    public void close() {
        RandomAccessStream os;
        if (this._isClosed.getAndSet(true)) {
            return;
        }
        RandomAccessStream is = this._cachedRead.getAndSet(null);
        if (is != null) {
            is.close();
        }
        if ((os = (RandomAccessStream)this._cachedWrite.getAndSet(null)) != null) {
            os.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }

    class StreamWrite
    implements OutStore {
        private RandomAccessStream _os;

        StreamWrite(RandomAccessStream os) {
            this._os = os;
        }

        RandomAccessStream getFile() {
            return this._os;
        }

        @Override
        public long getLength() {
            try {
                return this._os.getLength();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean write(long address, byte[] buffer, int offset, int length) {
            try {
                this._os.write(address, buffer, offset, length);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public StreamWrite clone() {
            return this;
        }

        @Override
        public void close() {
            RandomAccessStream os = this._os;
            this._os = null;
            if (os == null) {
                return;
            }
            os.free();
            if (StoreReadWriteImpl.this._cachedWrite.compareAndSet(null, os)) {
                return;
            }
            os.close();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._os + "]";
        }
    }

    class StreamRead
    implements InStore {
        private RandomAccessStream _is;

        StreamRead(RandomAccessStream is) {
            this._is = is;
        }

        RandomAccessStream getFile() {
            return this._is;
        }

        @Override
        public boolean read(long address, byte[] buffer, int offset, int length) {
            try {
                while (length > 0) {
                    int sublen = this._is.read(address, buffer, offset, length);
                    offset += sublen;
                    address += (long)sublen;
                    length -= sublen;
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InStore clone() {
            return this;
        }

        @Override
        public void close() {
            RandomAccessStream is = this._is;
            this._is = null;
            if (is == null) {
                return;
            }
            is.free();
            if (StoreReadWriteImpl.this._isClosed.get()) {
                is.close();
            } else {
                is.close();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._is + "]";
        }
    }
}

