/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;

public class NamespaceBeanConfig {
    private TypeFactory _factory;
    private String _name;
    private String _className;
    private ConfigType<?> _configType;
    private ClassLoader _loader;

    NamespaceBeanConfig(TypeFactory factory, String ns, boolean isDefault) {
        this._factory = factory;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setClass(String className) {
        this._className = className;
    }

    public ConfigType<?> getConfigType() {
        try {
            if (this._configType == null) {
                Class<?> cl = Class.forName(this._className, false, this._loader);
                ConfigType type = this._factory.createType(cl);
                type.setEnvBean(true);
                type.introspect();
                this._configType = type;
            }
            return this._configType;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

