/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class LongPrimitiveType
extends ConfigType {
    private static final L10N L = new L10N(LongPrimitiveType.class);
    public static final LongPrimitiveType TYPE = new LongPrimitiveType();
    private static final Long ZERO = new Long(0L);

    private LongPrimitiveType() {
    }

    public Class getType() {
        return Long.TYPE;
    }

    @Override
    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return ZERO;
        }
        return Long.valueOf(text);
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Long) {
            return value;
        }
        if (value == null) {
            return ZERO;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to a long", value));
    }
}

