/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.timer;

import com.caucho.config.timer.CronExpression;
import com.caucho.config.timer.CronTrigger;
import com.caucho.config.timer.EjbTimer;
import com.caucho.config.timer.MethodTimeoutInvoker;
import com.caucho.config.timer.TimeoutCaller;
import com.caucho.config.timer.TimerTask;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

public class ScheduleIntrospector {
    public ArrayList<TimerTask> introspect(TimeoutCaller caller, AnnotatedType<?> type) {
        ArrayList<TimerTask> timers = null;
        for (AnnotatedMethod method : type.getMethods()) {
            Schedule schedule;
            Schedules schedules = (Schedules)method.getAnnotation(Schedules.class);
            if (schedules != null) {
                if (timers == null) {
                    timers = new ArrayList<TimerTask>();
                }
                for (Schedule schedule2 : schedules.value()) {
                    this.addSchedule(timers, schedule2, caller, this.getScheduledMethod(method));
                }
            }
            if ((schedule = (Schedule)method.getAnnotation(Schedule.class)) == null) continue;
            if (timers == null) {
                timers = new ArrayList();
            }
            this.addSchedule(timers, schedule, caller, this.getScheduledMethod(method));
        }
        return timers;
    }

    protected Method getScheduledMethod(AnnotatedMethod<?> method) {
        return method.getJavaMember();
    }

    private void addSchedule(ArrayList<TimerTask> timers, Schedule schedule, TimeoutCaller caller, Method method) {
        CronExpression cronExpression = new CronExpression(schedule.second(), schedule.minute(), schedule.hour(), schedule.dayOfWeek(), schedule.dayOfMonth(), schedule.month(), schedule.year());
        TimeZone timezone = null;
        if (!schedule.timezone().trim().equals("")) {
            timezone = TimeZone.getTimeZone(schedule.timezone());
        }
        CronTrigger trigger = new CronTrigger(cronExpression, -1L, -1L, timezone);
        EjbTimer ejbTimer = new EjbTimer();
        MethodTimeoutInvoker timeoutInvoker = new MethodTimeoutInvoker(caller, method);
        TimerTask timerTask = new TimerTask(null, timeoutInvoker, ejbTimer, cronExpression, trigger, (Serializable)((Object)schedule.info()));
        ejbTimer.setScheduledTask(timerTask);
        timers.add(timerTask);
    }
}

