/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.ClassType;
import com.caucho.inject.Module;
import java.lang.reflect.Type;
import java.util.Set;

@Module
public class BoxType
extends ClassType {
    private Class<?> _boxType;

    public BoxType(Class<?> type, Class<?> boxType) {
        super(type);
        this._boxType = boxType;
    }

    @Override
    public Class<?> getRawClass() {
        return this._boxType;
    }

    @Override
    public boolean isParamAssignableFrom(BaseType type) {
        if (this._boxType.equals(type.getRawClass())) {
            return true;
        }
        return type.isWildcard();
    }

    @Override
    public boolean isAssignableFrom(BaseType type) {
        if (!this._boxType.isAssignableFrom(type.getRawClass())) {
            return false;
        }
        if (type.getParameters().length > 0) {
            for (BaseType param : type.getParameters()) {
                if (OBJECT_TYPE.isParamAssignableFrom(param)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public void fillTypeClosure(InjectManager manager, Set<Type> typeSet) {
        typeSet.add(this.toType());
        typeSet.add((Type)((Object)Object.class));
    }

    @Override
    public int hashCode() {
        return this._boxType.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoxType)) {
            return false;
        }
        BoxType type = (BoxType)o;
        return this._boxType.equals(type._boxType);
    }

    @Override
    public String toString() {
        return super.getRawClass().getName();
    }
}

