/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotationSet;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.BaseTypeAnnotated;
import com.caucho.config.reflect.VarType;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class AnnotatedElementImpl
implements Annotated,
BaseTypeAnnotated {
    private static final AnnotationSet NULL_ANN_SET = new AnnotationSet();
    private BaseType _type;
    private Set<Type> _typeSet;
    private AnnotationSet _annSet;
    private AnnotationSet _analysisAnnSet;
    private Annotated _sourceAnnotated;

    public AnnotatedElementImpl(BaseType type, Annotated annotated, Annotation[] annList) {
        Set annSet;
        this._type = type;
        if (annotated != null && (annSet = annotated.getAnnotations()) != null && annSet.size() > 0) {
            this._annSet = new AnnotationSet(annSet);
        }
        if (annList != null && annList.length > 0) {
            if (this._annSet == null) {
                this._annSet = new AnnotationSet();
            }
            for (Annotation ann : annList) {
                this._annSet.add(ann);
            }
        }
        this._sourceAnnotated = annotated;
    }

    public AnnotatedElementImpl(Annotated annotated) {
        this(AnnotatedElementImpl.createBaseType(annotated), annotated, null);
    }

    public AnnotatedElementImpl(Class<?> cl, Annotated annotated, Annotation[] annotationList) {
        this(AnnotatedElementImpl.createBaseType(cl), annotated, annotationList);
    }

    protected static BaseType createBaseType(Annotated ann) {
        if (ann instanceof BaseTypeAnnotated) {
            return ((BaseTypeAnnotated)ann).getBaseTypeImpl();
        }
        return AnnotatedElementImpl.createBaseType(ann.getBaseType());
    }

    protected static BaseType createBaseType(AnnotatedType<?> declaringType) {
        if (declaringType instanceof BaseTypeAnnotated) {
            return ((BaseTypeAnnotated)declaringType).getBaseTypeImpl();
        }
        return AnnotatedElementImpl.createBaseType(declaringType.getBaseType());
    }

    protected static BaseType createBaseType(AnnotatedType<?> declaringType, Type type) {
        HashMap<String, BaseType> paramMap = null;
        String paramDeclName = null;
        return AnnotatedElementImpl.createBaseType(declaringType, type, paramMap, paramDeclName);
    }

    protected static BaseType createBaseType(AnnotatedType<?> declaringType, Type type, String paramDeclName) {
        HashMap<String, BaseType> paramMap = null;
        return AnnotatedElementImpl.createBaseType(declaringType, type, paramMap, paramDeclName);
    }

    protected static BaseType createBaseType(AnnotatedType<?> declaringType, Type type, HashMap<String, BaseType> paramMap, String paramDeclName) {
        BaseType baseType = AnnotatedElementImpl.createBaseType(declaringType, type, paramMap, paramDeclName, BaseType.ClassFill.PLAIN);
        return baseType;
    }

    protected static BaseType createBaseType(AnnotatedType<?> declaringType, Type type, HashMap<String, BaseType> paramMap, String paramDeclName, BaseType.ClassFill classFill) {
        if (declaringType instanceof BaseTypeAnnotated) {
            BaseTypeAnnotated baseTypeAnn = (BaseTypeAnnotated)declaringType;
            if (paramMap == null) {
                paramMap = baseTypeAnn.getBaseTypeParamMap();
            }
            return BaseType.create(type, paramMap, paramDeclName, classFill);
        }
        return AnnotatedElementImpl.createBaseType(type);
    }

    protected static BaseType createBaseType(Type type) {
        InjectManager cdiManager = InjectManager.getCurrent();
        return cdiManager.createSourceBaseType(type);
    }

    public Type getBaseType() {
        return this._type.toType();
    }

    @Override
    public BaseType getBaseTypeImpl() {
        return this._type;
    }

    @Override
    public HashMap<String, BaseType> getBaseTypeParamMap() {
        return this.getBaseTypeImpl().getParamMap();
    }

    @Override
    public Set<VarType<?>> getTypeVariables() {
        HashSet typeVariables = new HashSet();
        this.fillTypeVariables(typeVariables);
        return typeVariables;
    }

    protected void fillTypeVariables(Set<VarType<?>> typeVariables) {
        this.getBaseTypeImpl().fillSyntheticTypes(typeVariables);
    }

    public Set<Type> getTypeClosure() {
        if (this._typeSet == null) {
            InjectManager cdiManager = InjectManager.getCurrent();
            this._typeSet = this._type.getTypeClosure(cdiManager);
        }
        return this._typeSet;
    }

    public void addAnnotations(Collection<Annotation> annSet) {
        for (Annotation ann : annSet) {
            this.addAnnotation(ann);
        }
    }

    public void addAnnotations(Annotation[] annSet) {
        for (Annotation ann : annSet) {
            this.addAnnotation(ann);
        }
    }

    public void addAnnotation(Annotation newAnn) {
        if (this._annSet == null) {
            this._annSet = new AnnotationSet();
        }
        this._annSet.replace(newAnn);
    }

    public void addAnnotationIfAbsent(Annotation newAnn) {
        if (!this.isAnnotationPresent(newAnn.annotationType())) {
            this.addAnnotation(newAnn);
        }
    }

    public void removeAnnotation(Annotation ann) {
        if (this._annSet == null) {
            return;
        }
        this._annSet.remove(ann);
    }

    public void clearAnnotations() {
        if (this._annSet != null) {
            this._annSet.clear();
        }
    }

    @Override
    public void addOverrideAnnotation(Annotation ann) {
        this._annSet.add(ann);
        if (this._sourceAnnotated instanceof BaseTypeAnnotated) {
            BaseTypeAnnotated baseAnn = (BaseTypeAnnotated)this._sourceAnnotated;
            baseAnn.addOverrideAnnotation(ann);
        }
    }

    @Override
    public void addAnalysisAnnotation(Annotation ann) {
        if (ann == null) {
            throw new NullPointerException();
        }
        if (this._analysisAnnSet == null) {
            this._analysisAnnSet = new AnnotationSet();
        }
        this._analysisAnnSet.add(ann);
        if (this._sourceAnnotated instanceof BaseTypeAnnotated) {
            BaseTypeAnnotated baseAnn = (BaseTypeAnnotated)this._sourceAnnotated;
            baseAnn.addAnalysisAnnotation(ann);
        }
    }

    @Override
    public <T extends Annotation> T getAnalysisAnnotation(Class<T> annType) {
        Annotation ann;
        if (this._analysisAnnSet != null && (ann = this._analysisAnnSet.getAnnotation(annType)) != null) {
            return (T)ann;
        }
        return this.getAnnotation(annType);
    }

    public Set<Annotation> getAnnotations() {
        if (this._annSet != null) {
            return this._annSet;
        }
        return NULL_ANN_SET;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annType) {
        if (this._annSet == null) {
            return null;
        }
        return (T)this._annSet.getAnnotation(annType);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annType) {
        if (this._annSet == null) {
            return false;
        }
        return this._annSet.isAnnotationPresent(annType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }
}

