/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.AnyLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.j2ee.JavaeeInjectionHandler;
import com.caucho.config.program.BeanValueGenerator;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FieldGeneratorProgram;
import com.caucho.config.program.MethodGeneratorProgram;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;

public class PersistenceUnitHandler
extends JavaeeInjectionHandler {
    private static final L10N L = new L10N(PersistenceUnitHandler.class);

    public PersistenceUnitHandler(InjectManager manager) {
        super(manager);
    }

    @Override
    public ConfigProgram introspectField(AnnotatedField<?> field) {
        PersistenceUnit pUnit = (PersistenceUnit)field.getAnnotation(PersistenceUnit.class);
        Field javaField = field.getJavaMember();
        if (!javaField.getType().isAssignableFrom(EntityManagerFactory.class)) {
            throw new ConfigException(L.l("{0}: @PersistenceUnit field must be assignable from EntityManagerFactory.", (Object)this.getLocation(javaField)));
        }
        return this.generateContext(field, pUnit);
    }

    @Override
    public ConfigProgram introspectMethod(AnnotatedMethod<?> method) {
        PersistenceUnit pUnit = (PersistenceUnit)method.getAnnotation(PersistenceUnit.class);
        Method javaMethod = method.getJavaMember();
        Class<EntityManagerFactory> param = null;
        if (javaMethod.getParameterTypes().length == 1) {
            param = javaMethod.getParameterTypes()[0];
        }
        if (param == null || !param.isAssignableFrom(EntityManagerFactory.class)) {
            throw new ConfigException(L.l("{0}: @PersistenceUnit method must be assignable from EntityManagerFactory.", (Object)this.getLocation(javaMethod)));
        }
        return this.generateContext(method, pUnit);
    }

    private ConfigProgram generateContext(AnnotatedField<?> field, PersistenceUnit pUnit) throws ConfigException {
        Field javaField = field.getJavaMember();
        String location = this.getLocation(javaField);
        BeanValueGenerator gen = this.bind(location, pUnit);
        return new FieldGeneratorProgram(javaField, gen);
    }

    private ConfigProgram generateContext(AnnotatedMethod<?> method, PersistenceUnit pUnit) throws ConfigException {
        Method javaMethod = method.getJavaMember();
        String location = this.getLocation(javaMethod);
        BeanValueGenerator gen = this.bind(location, pUnit);
        return new MethodGeneratorProgram(javaMethod, gen);
    }

    private BeanValueGenerator bind(String location, PersistenceUnit pUnit) {
        String name = pUnit.name();
        String unitName = pUnit.unitName();
        Bean<?> bean = null;
        if (!"".equals(unitName) && (bean = this.bind(location, EntityManagerFactory.class, unitName, new Annotation[0])) == null) {
            Set<Bean<?>> beans = this.getManager().getBeans((Type)((Object)EntityManagerFactory.class), new Annotation[]{AnyLiteral.ANY});
            throw new ConfigException(location + L.l("unitName='{0}' is an unknown @PersistenceUnit.\n  {1}", (Object)unitName, (Object)beans));
        }
        if (bean == null) {
            bean = this.bind(location, EntityManagerFactory.class, name, new Annotation[0]);
        }
        if (bean == null && "".equals(unitName)) {
            if (!"".equals(name)) {
                Set<Bean<?>> beans = this.getManager().getBeans((Type)((Object)EntityManagerFactory.class), new Annotation[]{AnyLiteral.ANY});
                throw new ConfigException(location + L.l("name='{0}' is an unknown @PersistenceUnit.\n  {1}", (Object)name, (Object)beans));
            }
            throw new ConfigException(location + L.l("@PersistenceUnit cannot find any persistence contexts.  No JPA persistence-units have been deployed"));
        }
        BeanValueGenerator gen = new BeanValueGenerator(location, bean);
        return gen;
    }
}

