/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AspectGeneratorUtil;
import com.caucho.config.gen.MethodHeadFactory;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

@Module
public class MethodHeadGenerator<X>
extends AbstractAspectGenerator<X> {
    public MethodHeadGenerator(MethodHeadFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        super(factory, method, next);
    }

    protected String getMethodNamePrefix() {
        return "";
    }

    protected String getMethodName() {
        return this.getMethodNamePrefix() + this.getJavaMethod().getName();
    }

    protected boolean isOverride() {
        return true;
    }

    @Override
    public final void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        this.generateMethodPrologue(out, prologueMap);
        int modifiers = this.getJavaMethod().getModifiers();
        String accessModifier = null;
        if (Modifier.isPublic(modifiers)) {
            accessModifier = "public";
        } else if (Modifier.isProtected(modifiers)) {
            accessModifier = "protected";
        }
        AspectGeneratorUtil.generateHeader(out, this.isOverride(), accessModifier, this.getMethodName(), this.getMethod(), this.getTypeVariables(), this.getThrowsExceptions());
        out.println("{");
        out.pushDepth();
        this.generateContent(out, prologueMap);
        out.popDepth();
        out.println("}");
    }

    public int hashCode() {
        return this.getJavaMethod().getName().hashCode();
    }

    public boolean equals(Object o) {
        Method bMethod;
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodHeadGenerator)) {
            return false;
        }
        MethodHeadGenerator bizMethod = (MethodHeadGenerator)o;
        Method aMethod = this.getJavaMethod();
        return AnnotatedTypeUtil.isMatch(aMethod, bMethod = bizMethod.getJavaMethod()) && aMethod.getDeclaringClass().equals(bMethod.getDeclaringClass());
    }
}

