/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.CandiUtil;
import com.caucho.config.gen.LifecycleMethodTailFactory;
import com.caucho.config.gen.MethodTailGenerator;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

@Module
public class LifecycleMethodTailGenerator<X>
extends MethodTailGenerator<X> {
    private String _invokeMethodName;

    public LifecycleMethodTailGenerator(LifecycleMethodTailFactory<X> factory, AnnotatedMethod<? super X> method) {
        super(factory, method);
        Method javaMethod = method.getJavaMember();
        String declName = javaMethod.getDeclaringClass().getSimpleName();
        String methodName = javaMethod.getName();
        this._invokeMethodName = "__caucho_postConstruct_" + declName + "_" + methodName;
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        Method method = this.getMethod().getJavaMember();
        out.println("private static final java.lang.reflect.Method " + this._invokeMethodName);
        out.print(" = " + CandiUtil.class.getName() + ".findMethod(");
        out.print(method.getDeclaringClass().getName());
        out.println(".class, \"" + method.getName() + "\");");
        out.println("static {");
        out.println("  " + this._invokeMethodName + ".setAccessible(true);");
        out.println("}");
        out.println();
        out.println("public void " + this._invokeMethodName + "()");
        out.println("{");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        String superVar = this._factory.getAspectBeanFactory().getInterceptorInstance();
        out.println("if (" + superVar + " != null)");
        out.println("  " + this._invokeMethodName + ".invoke(" + superVar + ");");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (java.lang.reflect.InvocationTargetException e) {");
        out.println("  if (e.getCause() instanceof RuntimeException)");
        out.println("    throw (RuntimeException) e.getCause();");
        out.println("  else");
        out.println("  throw new RuntimeException(e.getCause());");
        out.println("} catch (Exception e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        Method method = this.getMethod().getJavaMember();
        String methodName = method.getName();
        out.println(this._invokeMethodName + "();");
    }
}

