/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.bytecode;

import com.caucho.bytecode.CodeWriterAttribute;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaMethod;
import com.caucho.config.ConfigException;
import com.caucho.inject.Module;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.ProxyClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class DecoratorAdapter<T> {
    private static final L10N L = new L10N(DecoratorAdapter.class);
    private static final Logger log = Logger.getLogger(DecoratorAdapter.class.getName());
    private final Class<T> _cl;
    private Class<T> _proxyClass;
    private Constructor<?> _proxyCtor;
    private static HashMap<Class<?>, String> _prim = new HashMap();

    private DecoratorAdapter(Class<T> cl) {
        this._cl = cl;
        this.generateProxy(this._cl);
    }

    public static <T> Class<T> create(Class<T> cl) {
        if (!Modifier.isAbstract(cl.getModifiers())) {
            return cl;
        }
        DecoratorAdapter<T> adapter = new DecoratorAdapter<T>(cl);
        return adapter.getProxyClass();
    }

    public Class<T> getProxyClass() {
        return this._proxyClass;
    }

    private void generateProxy(Class<?> cl) {
        try {
            String typeClassName;
            String thisClassName;
            Constructor<?> zeroCtor = null;
            for (Constructor<?> ctorItem : cl.getDeclaredConstructors()) {
                if (ctorItem.getParameterTypes().length != 0) continue;
                zeroCtor = ctorItem;
                break;
            }
            if (zeroCtor == null && !cl.isInterface()) {
                throw new ConfigException(L.l("'{0}' does not have a zero-arg public or protected constructor.  Scope adapter components need a zero-arg constructor, e.g. @RequestScoped stored in @ApplicationScoped.", (Object)cl.getName()));
            }
            if (zeroCtor != null) {
                zeroCtor.setAccessible(true);
            }
            if ((thisClassName = (typeClassName = cl.getName().replace('.', '/')) + "__ResinDecoratorAdapter").startsWith("java")) {
                thisClassName = "cdi/" + thisClassName;
            }
            String cleanName = thisClassName.replace('/', '.');
            boolean isPackagePrivate = false;
            if (!Modifier.isPublic(cl.getModifiers()) && !Modifier.isProtected(cl.getModifiers())) {
                isPackagePrivate = true;
            }
            DynamicClassLoader loader = isPackagePrivate ? (DynamicClassLoader)cl.getClassLoader() : (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
            try {
                this._proxyClass = Class.forName(cleanName, false, loader);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            if (this._proxyClass != null) {
                return;
            }
            JavaClassLoader jLoader = new JavaClassLoader(cl.getClassLoader());
            JavaClass jClass = new JavaClass(jLoader);
            jClass.setAccessFlags(1);
            jClass.setWrite(true);
            jClass.setMajor(49);
            jClass.setMinor(0);
            String superClassName = !cl.isInterface() ? typeClassName : "java/lang/Object";
            jClass.setSuperClass(superClassName);
            jClass.setThisClass(thisClassName);
            JavaMethod ctor = jClass.createMethod("<init>", "()V");
            ctor.setAccessFlags(1);
            CodeWriterAttribute code = ctor.createCodeWriter();
            code.setMaxLocals(3);
            code.setMaxStack(4);
            code.pushObjectVar(0);
            code.invokespecial(superClassName, "<init>", "()V", 1, 0);
            code.addReturn();
            code.close();
            for (Method method : this._cl.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || !Modifier.isAbstract(method.getModifiers())) continue;
                this.createStubMethod(jClass, method);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            WriteStream out = Vfs.openWrite(bos);
            jClass.write(out);
            out.close();
            byte[] buffer = bos.toByteArray();
            if (isPackagePrivate) {
                this._proxyClass = loader.loadClass(cleanName, buffer);
            } else {
                ProxyClassLoader proxyLoader = new ProxyClassLoader(loader);
                this._proxyClass = proxyLoader.loadClass(cleanName, buffer);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createStubMethod(JavaClass jClass, Method method) {
        if (!Modifier.isAbstract(method.getModifiers())) {
            return;
        }
        String descriptor = this.createDescriptor(method);
        JavaMethod jMethod = jClass.createMethod(method.getName(), descriptor);
        jMethod.setAccessFlags(1);
        Class<?>[] parameterTypes = method.getParameterTypes();
        CodeWriterAttribute code = jMethod.createCodeWriter();
        code.setMaxLocals(1 + 2 * parameterTypes.length);
        code.setMaxStack(3 + 2 * parameterTypes.length);
        String exnClass = UnsupportedOperationException.class.getName();
        exnClass = exnClass.replace('.', '/');
        code.newInstance(exnClass);
        code.dup();
        code.invokespecial(exnClass, "<init>", "()V", 1, 1);
        code.addThrow();
        code.close();
    }

    private String createDescriptor(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> param : method.getParameterTypes()) {
            sb.append(this.createDescriptor(param));
        }
        sb.append(")");
        sb.append(this.createDescriptor(method.getReturnType()));
        return sb.toString();
    }

    private String createDescriptor(Class<?> cl) {
        if (cl.isArray()) {
            return "[" + this.createDescriptor(cl.getComponentType());
        }
        String primValue = _prim.get(cl);
        if (primValue != null) {
            return primValue;
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    static {
        _prim.put(Boolean.TYPE, "Z");
        _prim.put(Byte.TYPE, "B");
        _prim.put(Character.TYPE, "C");
        _prim.put(Short.TYPE, "S");
        _prim.put(Integer.TYPE, "I");
        _prim.put(Long.TYPE, "J");
        _prim.put(Float.TYPE, "F");
        _prim.put(Double.TYPE, "D");
        _prim.put(Void.TYPE, "V");
    }
}

