/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.xml.QName;
import java.lang.reflect.Method;

public class CreateAttribute<T>
extends Attribute {
    private final Method _create;
    private final Method _setter;
    private Class<T> _type;
    private ConfigType<T> _configType;

    public CreateAttribute(Method create, Class<T> type) {
        this._create = create;
        if (this._create != null) {
            this._create.setAccessible(true);
        }
        this._type = type;
        this._setter = null;
    }

    public CreateAttribute(Method create, Class<T> type, Method setter) {
        this._create = create;
        if (this._create != null) {
            this._create.setAccessible(true);
        }
        this._type = type;
        this._setter = setter;
        if (this._setter != null) {
            this._setter.setAccessible(true);
        }
    }

    @Override
    public ConfigType<?> getConfigType() {
        if (this._configType == null) {
            this._configType = TypeFactory.getType(this._type);
        }
        return this._configType;
    }

    @Override
    public boolean isAllowText() {
        return false;
    }

    @Override
    public boolean isAllowInline() {
        return this._setter != null;
    }

    @Override
    public boolean isInlineType(ConfigType<?> type) {
        if (this._setter == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        return this._type.isAssignableFrom(type.getType());
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            if (this._setter != null) {
                this._setter.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    @Override
    public boolean isSetter() {
        return this._setter != null;
    }

    @Override
    public Object create(Object parent, QName name) throws ConfigException {
        try {
            return this._create.invoke(parent, new Object[0]);
        }
        catch (Exception e) {
            throw ConfigException.create(this._create, (Throwable)e);
        }
    }

    @Override
    public boolean isAssignableFrom(Attribute attr) {
        if (!(attr instanceof CreateAttribute)) {
            return false;
        }
        CreateAttribute createAttr = (CreateAttribute)attr;
        Method create = createAttr._create;
        if (create == null || this._create == null) {
            return false;
        }
        if (!this._create.getName().equals(create.getName())) {
            return false;
        }
        if (!this._create.getDeclaringClass().isAssignableFrom(create.getDeclaringClass())) {
            return false;
        }
        Method setter = createAttr._setter;
        if (setter == null != (this._setter == null)) {
            return false;
        }
        if (setter == null) {
            return true;
        }
        if (!this._setter.getName().equals(setter.getName())) {
            return false;
        }
        return this._setter.getDeclaringClass().isAssignableFrom(setter.getDeclaringClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CreateAttribute attr = (CreateAttribute)o;
        return this._type.equals(attr._type) && this._setter == attr._setter && this._create == attr._create;
    }
}

