/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import java.io.IOException;

public class MethodHandleConstant
extends ConstantPoolEntry {
    private int _baseMethodIndex;
    private int _nameAndTypeIndex;

    MethodHandleConstant(ConstantPool pool, int index, int referenceKind, int referenceIndex) {
        super(pool, index);
        this._baseMethodIndex = referenceKind;
        this._nameAndTypeIndex = referenceIndex;
    }

    public int getBaseMethodIndex() {
        return this._baseMethodIndex;
    }

    public String getName() {
        return this.getConstantPool().getNameAndType(this._nameAndTypeIndex).getName();
    }

    public String getType() {
        return this.getConstantPool().getNameAndType(this._nameAndTypeIndex).getType();
    }

    public void setNameAndType(String name, String type) {
        this._nameAndTypeIndex = this.getConstantPool().addNameAndType(name, type).getIndex();
    }

    @Override
    void write(ByteCodeWriter out) throws IOException {
        out.write(10);
        out.writeShort(this._baseMethodIndex);
        out.writeShort(this._nameAndTypeIndex);
    }

    @Override
    public int export(ConstantPool target) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "(" + this.getType() + ")]";
    }
}

