/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;

public class JClassArray
extends JClass {
    private JClass _componentType;

    JClassArray(JClass component) {
        if (component == null) {
            throw new NullPointerException();
        }
        this._componentType = component;
    }

    @Override
    public String getName() {
        return "[" + this._componentType.getName();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public JClass getSuperClass() {
        return JClass.OBJECT;
    }

    @Override
    public JClass[] getInterfaces() {
        return new JClass[0];
    }

    @Override
    public JMethod[] getConstructors() {
        return new JMethod[0];
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JClass getComponentType() {
        return this._componentType;
    }

    @Override
    public boolean isAssignableTo(Class cl) {
        return this.getName().equals(cl.getName());
    }

    @Override
    public boolean isAssignableFrom(Class cl) {
        return this.getName().equals(cl.getName());
    }

    @Override
    public boolean isAssignableFrom(JClass cl) {
        return this.getName().equals(cl.getName());
    }

    @Override
    public JMethod[] getDeclaredMethods() {
        return new JMethod[0];
    }

    @Override
    public JMethod[] getMethods() {
        return new JMethod[0];
    }

    @Override
    public JMethod getMethod(String name, JClass[] param) {
        return null;
    }

    @Override
    public JField[] getDeclaredFields() {
        return new JField[0];
    }

    @Override
    public JField[] getFields() {
        return new JField[0];
    }

    @Override
    public String getPrintName() {
        if (this.isArray()) {
            return this.getComponentType().getPrintName() + "[]";
        }
        return this.getName();
    }

    @Override
    public String getShortName() {
        if (this.isArray()) {
            return this.getComponentType().getShortName() + "[]";
        }
        String name = this.getName();
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            return name.substring(p + 1);
        }
        return name;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JClass jClass = (JClass)o;
        return this.getName().equals(jClass.getName());
    }

    @Override
    public String toString() {
        return "JClass[" + this.getName() + "]";
    }
}

