/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.StackTraceHolder;
import java.lang.ref.WeakReference;
import java.util.Random;

public final class AssertingRandom
extends Random {
    private final Random delegate;
    private final WeakReference<Thread> ownerRef;
    private final String ownerName;
    private final StackTraceElement[] allocationStack;
    private volatile boolean valid = true;

    public AssertingRandom(Thread owner, Random delegate) {
        super(0L);
        this.delegate = delegate;
        this.ownerRef = new WeakReference<Thread>(owner);
        this.ownerName = owner.toString();
        this.allocationStack = Thread.currentThread().getStackTrace();
    }

    @Override
    protected int next(int bits) {
        throw new RuntimeException("Shouldn't be reachable.");
    }

    @Override
    public boolean nextBoolean() {
        this.checkValid();
        return this.delegate.nextBoolean();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.checkValid();
        this.delegate.nextBytes(bytes);
    }

    @Override
    public double nextDouble() {
        this.checkValid();
        return this.delegate.nextDouble();
    }

    @Override
    public float nextFloat() {
        this.checkValid();
        return this.delegate.nextFloat();
    }

    @Override
    public double nextGaussian() {
        this.checkValid();
        return this.delegate.nextGaussian();
    }

    @Override
    public int nextInt() {
        this.checkValid();
        return this.delegate.nextInt();
    }

    @Override
    public int nextInt(int n) {
        this.checkValid();
        return this.delegate.nextInt(n);
    }

    @Override
    public long nextLong() {
        this.checkValid();
        return this.delegate.nextLong();
    }

    @Override
    public void setSeed(long seed) {
        if (seed == 0L && this.delegate == null) {
            return;
        }
        throw new RuntimeException(RandomizedRunner.class.getSimpleName() + " prevents changing the seed of its random generators to assure repeatability" + " of tests. If you need a mutable instance of Random, create a new instance," + " preferably with the initial seed aquired from this Random instance.");
    }

    public String toString() {
        this.checkValid();
        return this.delegate.toString();
    }

    public boolean equals(Object obj) {
        this.checkValid();
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        this.checkValid();
        return this.delegate.hashCode();
    }

    public void destroy() {
        this.valid = false;
    }

    private final void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("This Random instance has been invalidated and is probably used out of its allowed context (test or suite).");
        }
        Thread owner = (Thread)this.ownerRef.get();
        if (owner == null || Thread.currentThread() != owner) {
            StackTraceHolder allocationEx = new StackTraceHolder("Original allocation stack for this Random (allocated by " + this.ownerName + ")");
            allocationEx.setStackTrace(this.allocationStack);
            throw new IllegalStateException("This Random was created for/by another thread (" + this.ownerName + ")." + " Random instances must not be shared (acquire per-thread). Current thread: " + Thread.currentThread().toString(), allocationEx);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        this.checkValid();
        throw new CloneNotSupportedException("Don't clone test Randoms.");
    }
}

