/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLongAssociativeContainer;
import com.carrotsearch.hppc.ShortLongMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.WormUtil;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortLongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ShortLongPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ShortLongProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortLongWormMap
implements ShortLongMap,
Preallocable,
Cloneable,
Accountable {
    public short[] keys;
    public long[] values;
    public byte[] next;
    protected int size;
    protected int iterationSeed;

    public ShortLongWormMap() {
        this(4);
    }

    public ShortLongWormMap(int expectedElements) {
        if (expectedElements < 0) {
            throw new IllegalArgumentException("Invalid expectedElements=" + expectedElements);
        }
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ShortLongWormMap(ShortLongAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    public static ShortLongWormMap from(short[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortLongWormMap map = new ShortLongWormMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public ShortLongWormMap clone() {
        try {
            ShortLongWormMap cloneMap = (ShortLongWormMap)super.clone();
            cloneMap.keys = Arrays.copyOf(this.keys, this.keys.length);
            cloneMap.values = Arrays.copyOf(this.values, this.values.length);
            cloneMap.next = Arrays.copyOf(this.next, this.next.length);
            cloneMap.iterationSeed = HashContainers.nextIterationSeed();
            return cloneMap;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public long noValue() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long get(short key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
        return entryIndex < 0 ? this.noValue() : this.values[entryIndex];
    }

    @Override
    public long getOrDefault(short key, long defaultValue) {
        long value = this.get(key);
        return value == this.noValue() ? defaultValue : value;
    }

    @Override
    public long put(short key, long value) {
        return this.put(key, value, WormUtil.PutPolicy.NEW_OR_REPLACE, true);
    }

    @Override
    public int putAll(ShortLongAssociativeContainer container) {
        int initialSize = this.size();
        for (ShortLongCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public int putAll(Iterable<? extends ShortLongCursor> iterable) {
        int initialSize = this.size();
        for (ShortLongCursor shortLongCursor : iterable) {
            this.put(shortLongCursor.key, shortLongCursor.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public long putOrAdd(short key, long putValue, long incrementValue) {
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public long addTo(short key, long additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public boolean putIfAbsent(short key, long value) {
        return this.noValue() == this.put(key, value, WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT, true);
    }

    @Override
    public long remove(short key) {
        byte[] next = this.next;
        int hashIndex = this.hashMod(key);
        byte nextOffset = next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int previousEntryIndex = this.searchInChainReturnPrevious(key, hashIndex, nextOffset);
        if (previousEntryIndex < 0) {
            return this.noValue();
        }
        int entryToRemoveIndex = previousEntryIndex == Integer.MAX_VALUE ? hashIndex : WormUtil.addOffset(previousEntryIndex, Math.abs(next[previousEntryIndex]), next.length);
        return this.remove(hashIndex, previousEntryIndex, entryToRemoveIndex);
    }

    @Override
    public int removeAll(ShortContainer other) {
        int size = this.size();
        if (other.size() >= size && other instanceof ShortLookupContainer) {
            short[] keys = this.keys;
            byte[] next = this.next;
            int capacity = next.length;
            int entryIndex = 0;
            while (entryIndex < capacity) {
                short key;
                if (next[entryIndex] != 0 && other.contains(key = keys[entryIndex])) {
                    this.remove(key);
                    continue;
                }
                ++entryIndex;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        short[] keys = this.keys;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            short key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ShortLongPredicate predicate) {
        short[] keys = this.keys;
        long[] values = this.values;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            short key;
            if (next[entryIndex] != 0 && predicate.apply(key = keys[entryIndex], values[entryIndex])) {
                this.remove(key);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public <T extends ShortLongProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        long[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (next[slot] != 0) {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ShortLongPredicate> T forEach(T predicate) {
        short[] keys = this.keys;
        long[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (next[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    @Override
    public Iterator<ShortLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        return this.searchInChain(key, hashIndex, nextOffset) >= 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.next, (byte)0);
        this.size = 0;
    }

    @Override
    public void release() {
        this.keys = null;
        this.values = null;
        this.next = null;
        this.size = 0;
        this.ensureCapacity(4);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ShortLongMap)) {
            return false;
        }
        int size = this.size;
        ShortLongMap map = (ShortLongMap)o;
        if (size != map.size()) {
            return false;
        }
        short[] keys = this.keys;
        long[] values = this.values;
        byte[] next = this.next;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (next[index] != 0) {
                if (map.get(keys[index]) != values[index]) {
                    return false;
                }
                ++entryCount;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int size = this.size;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (this.next[index] != 0) {
                hashCode += WormUtil.hash(this.keys[index]) ^ WormUtil.hash(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        return hashCode;
    }

    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    private int hashMod(short key) {
        return this.hashKey(key) & this.next.length - 1;
    }

    @Override
    public int indexOf(short key) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return ~hashIndex;
        }
        return this.searchInChain(key, hashIndex, nextOffset);
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < this.next.length);
        return index >= 0;
    }

    @Override
    public long indexGet(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        return this.values[index];
    }

    @Override
    public long indexReplace(int index, long newValue) {
        assert (WormUtil.checkIndex(index, this.next.length));
        long previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, short key, long value) {
        assert (index < 0) : "The index must not point at an existing key.";
        if (this.next[index ^= 0xFFFFFFFF] == 0) {
            this.keys[index] = key;
            this.values[index] = value;
            this.next[index] = 127;
            ++this.size;
        } else {
            this.put(key, value, WormUtil.PutPolicy.NEW_GUARANTEED, true);
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append('[');
        int index = 0;
        int entryCount = 0;
        while (entryCount < this.size) {
            if (this.next[index] != 0) {
                if (entryCount > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(this.keys[index]);
                sBuilder.append("=>");
                sBuilder.append(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.allocateBuffers((int)((float)expectedElements / 0.75f));
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        throw new UnsupportedOperationException("Visualization is not supported yet");
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4) + RamUsageEstimator.shallowSizeOf(this.keys) + RamUsageEstimator.shallowSizeOf(this.values) + RamUsageEstimator.shallowSizeOf(this.next);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.next, this.size());
    }

    private void allocateBuffers(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException("Illegal capacity=" + capacity + " (size=" + this.size + ")");
        }
        if ((capacity = Math.max(BitUtil.nextHighestPowerOfTwo(capacity), 4)) > 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded (capacity: %d)", capacity);
        }
        if (this.keys != null && this.keys.length == capacity) {
            return;
        }
        short[] oldKeys = this.keys;
        long[] oldValues = this.values;
        byte[] oldNext = this.next;
        this.keys = new short[capacity];
        this.values = new long[capacity];
        this.next = new byte[capacity];
        if (oldKeys != null) {
            this.putOldEntries(oldKeys, oldValues, oldNext, this.size);
        }
    }

    private void putOldEntries(short[] oldKeys, long[] oldValues, byte[] oldNext, int entryNum) {
        int entryCount = 0;
        int endIndex = oldNext.length;
        for (int index = 0; entryCount < entryNum && index < endIndex; ++index) {
            if (oldNext[index] == 0) continue;
            short oldKey = oldKeys[index];
            int hashIndex = this.hashMod(oldKey);
            this.putNewEntry(hashIndex, this.next[hashIndex], oldKey, oldValues[index]);
            ++entryCount;
        }
    }

    private long put(short key, long value, WormUtil.PutPolicy policy, boolean sizeIncrease) {
        int hashIndex = this.hashMod(key);
        byte nextOffset = this.next[hashIndex];
        boolean added = false;
        if (nextOffset > 0 && policy != WormUtil.PutPolicy.NEW_GUARANTEED) {
            int entryIndex = this.searchInChain(key, hashIndex, nextOffset);
            if (entryIndex >= 0) {
                long previousValue = this.values[entryIndex];
                if (policy != WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT) {
                    this.values[entryIndex] = value;
                }
                return previousValue;
            }
            if (this.enlargeIfNeeded()) {
                hashIndex = this.hashMod(key);
                nextOffset = this.next[hashIndex];
            } else {
                if (!this.appendTailOfChain(~entryIndex, key, value)) {
                    this.enlargeAndPutNewEntry(key, value);
                }
                added = true;
            }
        } else if (this.enlargeIfNeeded()) {
            hashIndex = this.hashMod(key);
            nextOffset = this.next[hashIndex];
        }
        if (!added) {
            this.putNewEntry(hashIndex, nextOffset, key, value);
        }
        if (sizeIncrease) {
            ++this.size;
        }
        return this.noValue();
    }

    private boolean enlargeIfNeeded() {
        if (this.size >= this.next.length) {
            this.allocateBuffers(this.next.length << 1);
            return true;
        }
        return false;
    }

    private void enlargeAndPutNewEntry(short key, long value) {
        this.allocateBuffers(this.next.length << 1);
        this.put(key, value, WormUtil.PutPolicy.NEW_GUARANTEED, false);
    }

    private long remove(int headIndex, int previousEntryIndex, int entryToRemoveIndex) {
        int lastIndex;
        assert (WormUtil.checkIndex(headIndex, this.next.length));
        assert (this.next[headIndex] > 0);
        assert (previousEntryIndex == Integer.MAX_VALUE || WormUtil.checkIndex(previousEntryIndex, this.next.length));
        assert (WormUtil.checkIndex(entryToRemoveIndex, this.next.length));
        byte[] next = this.next;
        long previousValue = this.values[entryToRemoveIndex];
        int beforeLastIndex = WormUtil.findLastOfChain(entryToRemoveIndex, next[entryToRemoveIndex], true, next);
        if (beforeLastIndex == Integer.MAX_VALUE) {
            beforeLastIndex = previousEntryIndex;
            lastIndex = entryToRemoveIndex;
        } else {
            lastIndex = WormUtil.addOffset(beforeLastIndex, Math.abs(next[beforeLastIndex]), next.length);
        }
        if (entryToRemoveIndex != lastIndex) {
            this.keys[entryToRemoveIndex] = this.keys[lastIndex];
            this.values[entryToRemoveIndex] = this.values[lastIndex];
        }
        if (lastIndex != headIndex) {
            next[beforeLastIndex] = (byte)(beforeLastIndex == headIndex ? 127 : -127);
        }
        this.keys[lastIndex] = 0;
        this.values[lastIndex] = this.noValue();
        next[lastIndex] = 0;
        --this.size;
        return previousValue;
    }

    private boolean appendTailOfChain(int lastEntryIndex, short key, long value) {
        return this.appendTailOfChain(lastEntryIndex, key, value, WormUtil.ExcludedIndexes.NONE, 0);
    }

    private boolean appendTailOfChain(int lastEntryIndex, short key, long value, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        int capacity = this.next.length;
        int searchFromIndex = WormUtil.addOffset(lastEntryIndex, 1, capacity);
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, WormUtil.maxOffset(capacity), -1, this.next);
        if (freeIndex == -1 && (freeIndex = this.searchAndMoveBucket(searchFromIndex, WormUtil.maxOffset(capacity), excludedIndexes, recursiveCallLevel)) == -1) {
            return false;
        }
        this.keys[freeIndex] = key;
        this.values[freeIndex] = value;
        this.next[freeIndex] = -127;
        int nextOffset = WormUtil.getOffsetBetweenIndexes(lastEntryIndex, freeIndex, this.next.length);
        this.next[lastEntryIndex] = (byte)(this.next[lastEntryIndex] > 0 ? nextOffset : -nextOffset);
        return true;
    }

    private int searchAndMoveBucket(int fromIndex, int range, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        assert (WormUtil.checkIndex(fromIndex, this.next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(this.next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(this.next.length);
        int remainingAttempts = WormUtil.RECURSIVE_MOVE_ATTEMPTS[recursiveCallLevel];
        if (remainingAttempts <= 0 || range <= 0) {
            return -1;
        }
        byte[] next = this.next;
        int capacity = next.length;
        int nextRecursiveCallLevel = recursiveCallLevel + 1;
        for (int index = fromIndex + range - 1; index >= fromIndex; --index) {
            byte nextOffset;
            int rolledIndex = index & capacity - 1;
            if (excludedIndexes.isIndexExcluded(rolledIndex) || (nextOffset = next[rolledIndex]) >= 0) continue;
            if (this.moveTailOfChain(rolledIndex, nextOffset, excludedIndexes, nextRecursiveCallLevel)) {
                return rolledIndex;
            }
            if (--remainingAttempts > 0) continue;
            return -1;
        }
        return -1;
    }

    private void putNewEntry(int hashIndex, int nextOffset, short key, long value) {
        assert (hashIndex == this.hashMod(key)) : "hashIndex=" + hashIndex + ", hashReduce(key)=" + this.hashMod(key);
        assert (WormUtil.checkIndex(hashIndex, this.next.length));
        assert (Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[hashIndex]) : "nextOffset=" + nextOffset + ", next[hashIndex]=" + this.next[hashIndex];
        if (nextOffset > 0) {
            if (!this.appendTailOfChain(WormUtil.findLastOfChain(hashIndex, nextOffset, false, this.next), key, value)) {
                this.enlargeAndPutNewEntry(key, value);
            }
        } else {
            if (nextOffset < 0 && !this.moveTailOfChain(hashIndex, nextOffset, WormUtil.ExcludedIndexes.NONE, 0)) {
                this.enlargeAndPutNewEntry(key, value);
                return;
            }
            this.keys[hashIndex] = key;
            this.values[hashIndex] = value;
            this.next[hashIndex] = 127;
        }
    }

    private boolean moveTailOfChain(int tailIndex, int nextOffset, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        boolean nextIndexWithinRange;
        int searchRange;
        int searchFromIndex;
        assert (WormUtil.checkIndex(tailIndex, this.next.length));
        assert (nextOffset < 0 && nextOffset >= -127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[tailIndex]) : "nextOffset=" + nextOffset + ", next[tailIndex]=" + this.next[tailIndex];
        byte[] next = this.next;
        int capacity = next.length;
        int maxOffset = WormUtil.maxOffset(capacity);
        int previousIndex = WormUtil.findPreviousInChain(tailIndex, next);
        int absPreviousOffset = Math.abs(next[previousIndex]);
        int nextIndex = nextOffset == -127 ? -1 : WormUtil.addOffset(tailIndex, -nextOffset, capacity);
        int offsetFromPreviousToNext = absPreviousOffset - nextOffset;
        if (offsetFromPreviousToNext <= maxOffset) {
            searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
            searchRange = offsetFromPreviousToNext - 1;
            nextIndexWithinRange = true;
        } else {
            if (nextIndex == -1) {
                searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
                searchRange = maxOffset;
            } else {
                searchFromIndex = WormUtil.addOffset(nextIndex, -maxOffset, capacity);
                int searchToIndex = WormUtil.addOffset(previousIndex, maxOffset, capacity);
                searchRange = WormUtil.getOffsetBetweenIndexes(searchFromIndex, searchToIndex, capacity) + 1;
            }
            nextIndexWithinRange = false;
        }
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, searchRange, tailIndex, next);
        if (freeIndex == -1) {
            if (nextIndexWithinRange && this.appendTailOfChain(WormUtil.findLastOfChain(nextIndex, next[nextIndex], false, next), this.keys[tailIndex], this.values[tailIndex], excludedIndexes, recursiveCallLevel)) {
                int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, nextIndex, capacity);
                next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
                return true;
            }
            WormUtil.ExcludedIndexes recursiveExcludedIndexes = excludedIndexes.union(WormUtil.ExcludedIndexes.fromChain(previousIndex, next));
            freeIndex = this.searchAndMoveBucket(searchFromIndex, searchRange, recursiveExcludedIndexes, recursiveCallLevel);
            if (freeIndex == -1) {
                return false;
            }
        }
        this.keys[freeIndex] = this.keys[tailIndex];
        this.values[freeIndex] = this.values[tailIndex];
        next[freeIndex] = (byte)(nextOffset == -127 ? nextOffset : -WormUtil.getOffsetBetweenIndexes(freeIndex, nextIndex, capacity));
        int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, freeIndex, capacity);
        next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
        assert (next[freeIndex] < 0) : "freeIndex=" + freeIndex + ", next[freeIndex]=" + next[freeIndex];
        return true;
    }

    private int searchInChain(short key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (key == this.keys[index]) {
            return index;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            if (key == this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)]) {
                return index;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    private int searchInChainReturnPrevious(short key, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (key == this.keys[index]) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            int previousIndex = index;
            if (key == this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)]) {
                return previousIndex;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    private class EntryIterator
    extends AbstractIterator<ShortLongCursor> {
        private final ShortLongCursor cursor = new ShortLongCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ShortLongWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortLongWormMap.this.next.length - 1;
        }

        @Override
        protected ShortLongCursor fetch() {
            int mask = ShortLongWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortLongWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = ShortLongWormMap.this.keys[this.slot];
                this.cursor.value = ShortLongWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (ShortLongCursor)this.done();
        }
    }

    private class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = ShortLongWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortLongWormMap.this.next.length - 1;
        }

        @Override
        protected LongCursor fetch() {
            int mask = ShortLongWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortLongWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ShortLongWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private class ValuesContainer
    extends AbstractLongCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ShortLongWormMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ShortLongWormMap.this.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (ShortLongCursor c : ShortLongWormMap.this) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            for (ShortLongCursor c : ShortLongWormMap.this) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            for (ShortLongCursor c : ShortLongWormMap.this) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(long e) {
            return ShortLongWormMap.this.removeAll((short key, long value) -> value == e);
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return ShortLongWormMap.this.removeAll((short key, long value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            ShortLongWormMap.this.clear();
        }

        @Override
        public void release() {
            ShortLongWormMap.this.release();
        }
    }

    private class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = ShortLongWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortLongWormMap.this.next.length - 1;
        }

        @Override
        protected ShortCursor fetch() {
            int mask = ShortLongWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortLongWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ShortLongWormMap.this.keys[this.slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        KeysContainer() {
        }

        @Override
        public boolean contains(short e) {
            return ShortLongWormMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            ShortLongWormMap.this.forEach((key, value) -> procedure.apply(key));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            ShortLongWormMap.this.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return ShortLongWormMap.this.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return ShortLongWormMap.this.size();
        }

        @Override
        public void clear() {
            ShortLongWormMap.this.clear();
        }

        @Override
        public void release() {
            ShortLongWormMap.this.release();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return ShortLongWormMap.this.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            return ShortLongWormMap.this.remove(e) == ShortLongWormMap.this.noValue() ? 0 : 1;
        }
    }
}

