/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.virtual;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.IJavetDirectProxyHandler;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

public class V8VirtualIterator<T, E extends Exception>
implements IJavetDirectProxyHandler<E> {
    protected static final String FUNCTION_NEXT = "next";
    protected static final String PROPERTY_DONE = "done";
    protected static final String PROPERTY_VALUE = "value";
    protected Iterator<T> iterator;
    protected V8Runtime v8Runtime;
    protected T value;

    public V8VirtualIterator(Iterator<T> iterator) {
        this.iterator = Objects.requireNonNull(iterator);
        this.value = null;
        this.v8Runtime = null;
    }

    @Override
    public V8Runtime getV8Runtime() {
        return this.v8Runtime;
    }

    protected V8Value next(V8Value thisObject, V8Value ... v8Values) {
        if (this.iterator != null) {
            if (this.iterator.hasNext()) {
                this.value = this.iterator.next();
            } else {
                this.iterator = null;
                this.value = null;
            }
        }
        return thisObject;
    }

    @Override
    public V8Value proxyGet(V8Value target, V8Value property, V8Value receiver) throws JavetException, E {
        V8ValueSymbol propertySymbol;
        String description;
        if (property instanceof V8ValueString) {
            String propertyName = (String)((V8ValueString)property).getValue();
            if (FUNCTION_NEXT.equals(propertyName)) {
                return this.v8Runtime.createV8ValueFunction(new JavetCallbackContext(FUNCTION_NEXT, (Object)this, JavetCallbackType.DirectCallThisAndResult, this::next));
            }
            if (PROPERTY_DONE.equals(propertyName)) {
                return this.v8Runtime.createV8ValueBoolean(this.iterator == null);
            }
            if (PROPERTY_VALUE.equals(propertyName)) {
                if (this.iterator == null) {
                    return this.v8Runtime.createV8ValueUndefined();
                }
                return this.v8Runtime.toV8Value(this.value);
            }
        }
        if (property instanceof V8ValueSymbol && "Symbol.iterator".equals(description = (propertySymbol = (V8ValueSymbol)property).getDescription())) {
            return this.v8Runtime.createV8ValueFunction(new JavetCallbackContext(FUNCTION_NEXT, (Object)this, JavetCallbackType.DirectCallThisAndResult, (thisObject, v8Values) -> thisObject));
        }
        return IJavetDirectProxyHandler.super.proxyGet(target, property, receiver);
    }

    @Override
    public V8ValueArray proxyOwnKeys(V8Value target) throws JavetException, E {
        return V8ValueUtils.createV8ValueArray(this.v8Runtime, this.v8Runtime.createV8ValueString(PROPERTY_DONE), this.v8Runtime.createV8ValueString(PROPERTY_VALUE));
    }

    @Override
    public void setV8Runtime(V8Runtime v8Runtime) {
        this.v8Runtime = v8Runtime;
    }

    @Override
    public V8Value symbolToPrimitive(V8Value ... v8Values) throws JavetException, E {
        return this.v8Runtime.createV8ValueString(Optional.ofNullable(this.iterator).map(Object::toString).orElse(String.valueOf(null)));
    }
}

