/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.interfaces.IJavetLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavetDefaultLogger
implements IJavetLogger {
    protected Logger logger;
    protected String name;

    public JavetDefaultLogger(String name) {
        this.logger = Logger.getLogger(name);
        this.name = name;
    }

    @Override
    public void debug(String message) {
        this.logger.log(Level.FINE, message);
    }

    @Override
    public void error(String message) {
        this.logger.log(Level.SEVERE, message);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.logger.severe(message);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             PrintStream printStream = new PrintStream(byteArrayOutputStream);){
            cause.printStackTrace(printStream);
            this.logger.severe(byteArrayOutputStream.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void warn(String message) {
        this.logger.warning(message);
    }
}

