/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.enums.V8AllocationSpace;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import com.caoccao.javet.interop.monitoring.V8HeapSpaceStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class V8RuntimeObserverAverageV8HeapSpaceStatistics
implements IV8RuntimeObserver<V8HeapSpaceStatistics> {
    protected static final int DEFAULT_CAPACITY = 256;
    protected static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    protected final int timeoutMillis;
    protected final V8AllocationSpace v8AllocationSpace;
    protected final List<CompletableFuture<V8HeapSpaceStatistics>> v8HeapSpaceStatisticsFutureList;

    public V8RuntimeObserverAverageV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace) {
        this(v8AllocationSpace, 256, 5000);
    }

    public V8RuntimeObserverAverageV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace, int capacity, int timeoutMillis) {
        this.v8AllocationSpace = Objects.requireNonNull(v8AllocationSpace);
        this.timeoutMillis = timeoutMillis;
        this.v8HeapSpaceStatisticsFutureList = new ArrayList<CompletableFuture<V8HeapSpaceStatistics>>(capacity);
    }

    @Override
    public V8HeapSpaceStatistics getResult() {
        long physicalSpaceSize = 0L;
        long spaceAvailableSize = 0L;
        String spaceName = "";
        long spaceSize = 0L;
        long spaceUsedSize = 0L;
        if (!this.v8HeapSpaceStatisticsFutureList.isEmpty()) {
            int count = 0;
            long expectedEndTime = System.currentTimeMillis() + (long)this.timeoutMillis;
            for (CompletableFuture<V8HeapSpaceStatistics> v8HeapSpaceStatisticsFuture : this.v8HeapSpaceStatisticsFutureList) {
                try {
                    long now = System.currentTimeMillis();
                    V8HeapSpaceStatistics v8HeapSpaceStatistics = now < expectedEndTime ? v8HeapSpaceStatisticsFuture.get(expectedEndTime - now, TimeUnit.MILLISECONDS) : (V8HeapSpaceStatistics)v8HeapSpaceStatisticsFuture.getNow(null);
                    if (v8HeapSpaceStatistics == null) continue;
                    if (spaceName.isEmpty()) {
                        spaceName = v8HeapSpaceStatistics.getSpaceName();
                    }
                    physicalSpaceSize += v8HeapSpaceStatistics.getPhysicalSpaceSize();
                    spaceAvailableSize += v8HeapSpaceStatistics.getSpaceAvailableSize();
                    spaceSize += v8HeapSpaceStatistics.getSpaceSize();
                    spaceUsedSize += v8HeapSpaceStatistics.getSpaceUsedSize();
                    ++count;
                }
                catch (Throwable throwable) {}
            }
            if (count > 0) {
                physicalSpaceSize /= (long)count;
                spaceAvailableSize /= (long)count;
                spaceSize /= (long)count;
                spaceUsedSize /= (long)count;
            }
        }
        return new V8HeapSpaceStatistics(spaceName, physicalSpaceSize, spaceAvailableSize, spaceSize, spaceUsedSize).setAllocationSpace(this.v8AllocationSpace);
    }

    @Override
    public void observe(V8Runtime v8Runtime) {
        this.v8HeapSpaceStatisticsFutureList.add(v8Runtime.getV8HeapSpaceStatistics(this.v8AllocationSpace));
    }

    @Override
    public void reset() {
        this.v8HeapSpaceStatisticsFutureList.clear();
    }
}

