/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.converters;

import com.caoccao.javet.interop.binding.IClassProxyPlugin;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.interop.proxy.plugins.JavetProxyPluginArray;
import com.caoccao.javet.interop.proxy.plugins.JavetProxyPluginList;
import com.caoccao.javet.interop.proxy.plugins.JavetProxyPluginMap;
import com.caoccao.javet.interop.proxy.plugins.JavetProxyPluginSet;
import java.util.ArrayList;
import java.util.List;

public class JavetConverterConfig<T extends JavetConverterConfig<T>> {
    public static final int DEFAULT_MAX_DEPTH = 20;
    protected final List<IClassProxyPlugin> proxyPlugins = new ArrayList<IClassProxyPlugin>();
    protected boolean defaultBoolean = false;
    protected byte defaultByte = 0;
    protected char defaultChar = '\u0000';
    protected double defaultDouble = 0.0;
    protected float defaultFloat = 0.0f;
    protected int defaultInt = 0;
    protected long defaultLong = 0L;
    protected short defaultShort = 0;
    protected boolean extractFunctionSourceCode = false;
    protected int maxDepth = 20;
    protected IJavetReflectionObjectFactory reflectionObjectFactory = null;
    protected boolean sealedEnabled = false;
    protected boolean skipFunctionInObject = true;

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public char getDefaultChar() {
        return this.defaultChar;
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public float getDefaultFloat() {
        return this.defaultFloat;
    }

    public int getDefaultInt() {
        return this.defaultInt;
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public short getDefaultShort() {
        return this.defaultShort;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public List<IClassProxyPlugin> getProxyPlugins() {
        return this.proxyPlugins;
    }

    public IJavetReflectionObjectFactory getReflectionObjectFactory() {
        return this.reflectionObjectFactory;
    }

    public boolean isExtractFunctionSourceCode() {
        return this.extractFunctionSourceCode;
    }

    public boolean isProxyArrayEnabled() {
        return this.getProxyPlugins().stream().anyMatch(p -> p instanceof JavetProxyPluginArray);
    }

    public boolean isProxyListEnabled() {
        return this.getProxyPlugins().stream().anyMatch(p -> p instanceof JavetProxyPluginList);
    }

    public boolean isProxyMapEnabled() {
        return this.getProxyPlugins().stream().anyMatch(p -> p instanceof JavetProxyPluginMap);
    }

    public boolean isProxySetEnabled() {
        return this.getProxyPlugins().stream().anyMatch(p -> p instanceof JavetProxyPluginSet);
    }

    public boolean isSealedEnabled() {
        return this.sealedEnabled;
    }

    public boolean isSkipFunctionInObject() {
        return this.skipFunctionInObject;
    }

    public JavetConverterConfig<T> setDefaultBoolean(boolean defaultBoolean) {
        this.defaultBoolean = defaultBoolean;
        return this;
    }

    public JavetConverterConfig<T> setDefaultByte(byte defaultByte) {
        this.defaultByte = defaultByte;
        return this;
    }

    public JavetConverterConfig<T> setDefaultChar(char defaultChar) {
        this.defaultChar = defaultChar;
        return this;
    }

    public JavetConverterConfig<T> setDefaultDouble(double defaultDouble) {
        this.defaultDouble = defaultDouble;
        return this;
    }

    public JavetConverterConfig<T> setDefaultFloat(float defaultFloat) {
        this.defaultFloat = defaultFloat;
        return this;
    }

    public JavetConverterConfig<T> setDefaultInt(int defaultInt) {
        this.defaultInt = defaultInt;
        return this;
    }

    public JavetConverterConfig<T> setDefaultLong(long defaultLong) {
        this.defaultLong = defaultLong;
        return this;
    }

    public JavetConverterConfig<T> setDefaultShort(short defaultShort) {
        this.defaultShort = defaultShort;
        return this;
    }

    public JavetConverterConfig<T> setExtractFunctionSourceCode(boolean extractFunctionSourceCode) {
        this.extractFunctionSourceCode = extractFunctionSourceCode;
        return this;
    }

    public JavetConverterConfig<T> setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public JavetConverterConfig<T> setProxyArrayEnabled(boolean proxyArrayEnabled) {
        if (proxyArrayEnabled) {
            if (!this.isProxyArrayEnabled()) {
                this.getProxyPlugins().add(0, JavetProxyPluginArray.getInstance());
            }
        } else {
            this.getProxyPlugins().removeIf(p -> p instanceof JavetProxyPluginArray);
        }
        return this;
    }

    public JavetConverterConfig<T> setProxyListEnabled(boolean proxyListEnabled) {
        if (proxyListEnabled) {
            if (!this.isProxyListEnabled()) {
                this.getProxyPlugins().add(0, JavetProxyPluginList.getInstance());
            }
        } else {
            this.getProxyPlugins().removeIf(p -> p instanceof JavetProxyPluginList);
        }
        return this;
    }

    public JavetConverterConfig<T> setProxyMapEnabled(boolean proxyMapEnabled) {
        if (proxyMapEnabled) {
            if (!this.isProxyMapEnabled()) {
                this.getProxyPlugins().add(0, JavetProxyPluginMap.getInstance());
            }
        } else {
            this.getProxyPlugins().removeIf(p -> p instanceof JavetProxyPluginMap);
        }
        return this;
    }

    public JavetConverterConfig<T> setProxySetEnabled(boolean proxySetEnabled) {
        if (proxySetEnabled) {
            if (!this.isProxySetEnabled()) {
                this.getProxyPlugins().add(0, JavetProxyPluginSet.getInstance());
            }
        } else {
            this.getProxyPlugins().removeIf(p -> p instanceof JavetProxyPluginSet);
        }
        return this;
    }

    public JavetConverterConfig<T> setReflectionObjectFactory(IJavetReflectionObjectFactory reflectionObjectFactory) {
        this.reflectionObjectFactory = reflectionObjectFactory;
        return this;
    }

    public JavetConverterConfig<T> setSealedEnabled(boolean sealedEnabled) {
        this.sealedEnabled = sealedEnabled;
        return this;
    }

    public JavetConverterConfig<T> setSkipFunctionInObject(boolean skipFunctionInObject) {
        this.skipFunctionInObject = skipFunctionInObject;
        return this;
    }
}

