/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interop.V8Runtime;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;

public final class V8Guard
implements IJavetClosable {
    public static final int DEFAULT_TIMEOUT_MILLIS = 30000;
    private final long startTimeMillis;
    private final V8Runtime v8Runtime;
    private volatile boolean closed;
    private boolean debugModeEnabled;
    private long endTimeMillis;

    V8Guard(V8Runtime v8Runtime) {
        this(v8Runtime, 30000L, false);
    }

    V8Guard(V8Runtime v8Runtime, long timeoutMillis) {
        this(v8Runtime, timeoutMillis, false);
    }

    V8Guard(V8Runtime v8Runtime, long timeoutMillis, boolean debugModeEnabled) {
        assert (timeoutMillis > 0L) : "timeoutMillis must be greater than 0";
        this.closed = false;
        this.debugModeEnabled = debugModeEnabled;
        this.startTimeMillis = System.currentTimeMillis();
        this.v8Runtime = Objects.requireNonNull(v8Runtime);
        this.setTimeoutMillis(timeoutMillis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.isClosed()) {
            this.closed = true;
            Object object = this.v8Runtime.getCloseLock();
            synchronized (object) {
                PriorityBlockingQueue<V8Guard> v8GuardQueue = this.v8Runtime.getV8Host().getV8GuardDaemon().getV8GuardQueue();
                boolean bl = v8GuardQueue.remove(this);
            }
        }
    }

    @Override
    public void close() throws JavetException {
        this.cancel();
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getTimeoutMillis() {
        return this.endTimeMillis - this.startTimeMillis;
    }

    public V8Runtime getV8Runtime() {
        return this.v8Runtime;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.setTimeoutMillis(timeoutMillis, false);
    }

    private void setTimeoutMillis(long timeoutMillis, boolean addOnly) {
        this.endTimeMillis = this.startTimeMillis + timeoutMillis;
        if (!this.isClosed()) {
            PriorityBlockingQueue<V8Guard> v8GuardQueue = this.v8Runtime.getV8Host().getV8GuardDaemon().getV8GuardQueue();
            if (!addOnly) {
                boolean bl = v8GuardQueue.remove(this);
            }
            v8GuardQueue.add(this);
        }
    }
}

