/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.stream.Stream;

public enum V8ValueReferenceType {
    Invalid(0, "Invalid"),
    Object(1, "Object"),
    Error(2, "Error"),
    RegExp(3, "RegExp"),
    Promise(4, "Promise"),
    Proxy(5, "Proxy"),
    Symbol(6, "Symbol"),
    SymbolObject(7, "SymbolObject"),
    Arguments(8, "Arguments"),
    Map(9, "Map"),
    Set(10, "Set"),
    Array(11, "Array"),
    Function(12, "Function"),
    Iterator(13, "Iterator"),
    WeakMap(14, "WeakMap"),
    WeakSet(15, "WeakSet"),
    Script(20, "Script"),
    Module(21, "Module"),
    Context(22, "Context"),
    BigIntObject(23, "BigIntObject"),
    BooleanObject(24, "BooleanObject"),
    IntegerObject(25, "IntegerObject"),
    DoubleObject(26, "DoubleObject"),
    StringObject(27, "StringObject"),
    DataView(30, "DataView"),
    ArrayBuffer(31, "ArrayBuffer"),
    SharedArrayBuffer(32, "SharedArrayBuffer"),
    Int8Array(33, "Int8Array"),
    Uint8Array(34, "Uint8Array"),
    Uint8ClampedArray(35, "Uint8ClampedArray"),
    Int16Array(36, "Int16Array"),
    Uint16Array(37, "Uint16Array"),
    Int32Array(38, "Int32Array"),
    Uint32Array(39, "Uint32Array"),
    Float32Array(40, "Float32Array"),
    Float64Array(41, "Float64Array"),
    BigInt64Array(42, "BigInt64Array"),
    BigUint64Array(43, "BigUint64Array");

    private static final int LENGTH = 44;
    private static final V8ValueReferenceType[] TYPES;
    private final int id;
    private final String name;

    private V8ValueReferenceType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static V8ValueReferenceType parse(int id) {
        return id >= 0 && id < 44 ? TYPES[id] : Invalid;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        TYPES = new V8ValueReferenceType[44];
        Stream.of(V8ValueReferenceType.values()).forEach(v -> {
            V8ValueReferenceType.TYPES[v.getId()] = v;
        });
    }
}

