/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInJson;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInObject;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInPromise;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInSymbol;

public final class V8ValueGlobalObject
extends V8ValueObject {
    public static final String PROPERTY_JSON = "JSON";
    public static final String PROPERTY_PROMISE = "Promise";
    public static final String PROPERTY_SYMBOL = "Symbol";
    public static final String PROPERTY_OBJECT = "Object";

    V8ValueGlobalObject(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    protected void addReference() {
    }

    @Override
    public void clearWeak() {
    }

    @Override
    public void close(boolean forceClose) throws JavetException {
    }

    public V8ValueBuiltInJson getBuiltInJson() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor(PROPERTY_JSON).execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInJson(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", PROPERTY_JSON));
    }

    public V8ValueBuiltInObject getBuiltInObject() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor(PROPERTY_OBJECT).execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInObject(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", PROPERTY_OBJECT));
    }

    public V8ValueBuiltInPromise getBuiltInPromise() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor(PROPERTY_PROMISE).execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInPromise(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", PROPERTY_PROMISE));
    }

    public V8ValueBuiltInSymbol getBuiltInSymbol() throws JavetException {
        Object v8Value = this.v8Runtime.getExecutor(PROPERTY_SYMBOL).execute();
        if (v8Value instanceof V8ValueObject) {
            return new V8ValueBuiltInSymbol(this.v8Runtime, ((V8ValueObject)v8Value).getHandle());
        }
        JavetResourceUtils.safeClose(v8Value);
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", PROPERTY_SYMBOL));
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    @Override
    protected void removeReference() {
    }

    @Override
    public void setWeak() {
    }

    public V8ValueGlobalObject toClone(boolean referenceCopy) {
        return this;
    }
}

