/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ContextType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.reference.IV8ValueReference;
import java.math.BigInteger;

public interface IV8Context
extends IV8ValueReference {
    public <T extends V8Value> T get(int var1) throws JavetException;

    default public BigInteger getBigInteger(int index) throws JavetException {
        return (BigInteger)this.getPrimitive(index);
    }

    default public Boolean getBoolean(int index) throws JavetException {
        return (Boolean)this.getPrimitive(index);
    }

    default public Double getDouble(int index) throws JavetException {
        return (Double)this.getPrimitive(index);
    }

    default public Float getFloat(int index) throws JavetException {
        Double result = this.getDouble(index);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    default public Integer getInteger(int index) throws JavetException {
        return (Integer)this.getPrimitive(index);
    }

    public int getLength() throws JavetException;

    default public Long getLong(int index) throws JavetException {
        return (Long)this.getPrimitive(index);
    }

    default public V8ValueNull getNull(int index) throws JavetException {
        return (V8ValueNull)this.get(index);
    }

    default public <T> T getObject(int index) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.get(index), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R getPrimitive(int index) throws JavetException {
        try (T v8Value = this.get(index);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String getString(int index) throws JavetException {
        return (String)this.getPrimitive(index);
    }

    default public V8ValueUndefined getUndefined(int index) throws JavetException {
        return (V8ValueUndefined)this.get(index);
    }

    default public boolean isAwaitContext() throws JavetException {
        return this.isContextType(V8ContextType.Await);
    }

    default public boolean isBlockContext() throws JavetException {
        return this.isContextType(V8ContextType.Block);
    }

    default public boolean isCatchContext() throws JavetException {
        return this.isContextType(V8ContextType.Catch);
    }

    public boolean isContextType(V8ContextType var1) throws JavetException;

    default public boolean isDebugEvaluateContext() throws JavetException {
        return this.isContextType(V8ContextType.DebugEvaluate);
    }

    default public boolean isDeclarationContext() throws JavetException {
        return this.isContextType(V8ContextType.Declaration);
    }

    default public boolean isEvalContext() throws JavetException {
        return this.isContextType(V8ContextType.Eval);
    }

    default public boolean isFunctionContext() throws JavetException {
        return this.isContextType(V8ContextType.Function);
    }

    default public boolean isModuleContext() throws JavetException {
        return this.isContextType(V8ContextType.Module);
    }

    default public boolean isScriptContext() throws JavetException {
        return this.isContextType(V8ContextType.Script);
    }

    default public boolean isWithContext() throws JavetException {
        return this.isContextType(V8ContextType.With);
    }

    public boolean setLength(int var1) throws JavetException;
}

