/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.executors;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.executors.BaseV8Executor;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8Module;
import com.caoccao.javet.values.reference.V8Script;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;

public class V8StringExecutor
extends BaseV8Executor {
    protected byte[] cachedData;
    protected String scriptString;

    public V8StringExecutor(V8Runtime v8Runtime) {
        this(v8Runtime, null);
    }

    public V8StringExecutor(V8Runtime v8Runtime, String scriptString) {
        this(v8Runtime, scriptString, null);
    }

    public V8StringExecutor(V8Runtime v8Runtime, String scriptString, byte[] cachedData) {
        super(v8Runtime);
        this.scriptString = scriptString;
        this.cachedData = cachedData;
    }

    @Override
    public V8Module compileV8Module(boolean resultRequired) throws JavetException {
        return this.v8Runtime.compileV8Module(this.getScriptString(), this.getCachedData(), this.v8ScriptOrigin, resultRequired);
    }

    @Override
    public V8Script compileV8Script(boolean resultRequired) throws JavetException {
        return this.v8Runtime.compileV8Script(this.getScriptString(), this.getCachedData(), this.v8ScriptOrigin, resultRequired);
    }

    @Override
    public V8ValueFunction compileV8ValueFunction(String[] arguments, V8ValueObject[] contextExtensions) throws JavetException {
        return this.v8Runtime.compileV8ValueFunction(this.getScriptString(), this.getCachedData(), this.v8ScriptOrigin, arguments, contextExtensions);
    }

    @Override
    public <T extends V8Value> T execute(boolean resultRequired) throws JavetException {
        return this.v8Runtime.execute(this.getScriptString(), this.getCachedData(), this.v8ScriptOrigin, resultRequired);
    }

    @Override
    public byte[] getCachedData() {
        return this.cachedData;
    }

    @Override
    public String getScriptString() throws JavetException {
        return this.scriptString;
    }
}

