/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import com.caoccao.javet.interop.monitoring.V8HeapStatistics;
import java.util.ArrayList;
import java.util.List;

public class V8RuntimeObserverAverageV8HeapStatistics
implements IV8RuntimeObserver<V8HeapStatistics> {
    protected final List<V8HeapStatistics> v8HeapStatisticsList;

    public V8RuntimeObserverAverageV8HeapStatistics() {
        this(256);
    }

    public V8RuntimeObserverAverageV8HeapStatistics(int capacity) {
        this.v8HeapStatisticsList = new ArrayList<V8HeapStatistics>(capacity);
    }

    @Override
    public V8HeapStatistics getResult() {
        long doesZapGarbage = 0L;
        long externalMemory = 0L;
        long heapSizeLimit = 0L;
        long mallocedMemory = 0L;
        long numberOfDetachedContexts = 0L;
        long numberOfNativeContexts = 0L;
        long peakMallocedMemory = 0L;
        long totalAvailableSize = 0L;
        long totalGlobalHandlesSize = 0L;
        long totalHeapSize = 0L;
        long totalHeapSizeExecutable = 0L;
        long totalPhysicalSize = 0L;
        long usedGlobalHandlesSize = 0L;
        long usedHeapSize = 0L;
        if (!this.v8HeapStatisticsList.isEmpty()) {
            for (V8HeapStatistics v8HeapStatistics : this.v8HeapStatisticsList) {
                doesZapGarbage += v8HeapStatistics.getDoesZapGarbage();
                externalMemory += v8HeapStatistics.getExternalMemory();
                heapSizeLimit += v8HeapStatistics.getHeapSizeLimit();
                mallocedMemory += v8HeapStatistics.getMallocedMemory();
                numberOfDetachedContexts += v8HeapStatistics.getNumberOfDetachedContexts();
                numberOfNativeContexts += v8HeapStatistics.getNumberOfNativeContexts();
                peakMallocedMemory += v8HeapStatistics.getPeakMallocedMemory();
                totalAvailableSize += v8HeapStatistics.getTotalAvailableSize();
                totalGlobalHandlesSize += v8HeapStatistics.getTotalGlobalHandlesSize();
                totalHeapSize += v8HeapStatistics.getTotalHeapSize();
                totalHeapSizeExecutable += v8HeapStatistics.getTotalHeapSizeExecutable();
                totalPhysicalSize += v8HeapStatistics.getTotalPhysicalSize();
                usedGlobalHandlesSize += v8HeapStatistics.getUsedGlobalHandlesSize();
                usedHeapSize += v8HeapStatistics.getUsedHeapSize();
            }
            int v8RuntimeCount = this.v8HeapStatisticsList.size();
            doesZapGarbage /= (long)v8RuntimeCount;
            externalMemory /= (long)v8RuntimeCount;
            heapSizeLimit /= (long)v8RuntimeCount;
            mallocedMemory /= (long)v8RuntimeCount;
            numberOfDetachedContexts /= (long)v8RuntimeCount;
            numberOfNativeContexts /= (long)v8RuntimeCount;
            peakMallocedMemory /= (long)v8RuntimeCount;
            totalAvailableSize /= (long)v8RuntimeCount;
            totalGlobalHandlesSize /= (long)v8RuntimeCount;
            totalHeapSize /= (long)v8RuntimeCount;
            totalHeapSizeExecutable /= (long)v8RuntimeCount;
            totalPhysicalSize /= (long)v8RuntimeCount;
            usedGlobalHandlesSize /= (long)v8RuntimeCount;
            usedHeapSize /= (long)v8RuntimeCount;
        }
        return new V8HeapStatistics(doesZapGarbage, externalMemory, heapSizeLimit, mallocedMemory, numberOfDetachedContexts, numberOfNativeContexts, peakMallocedMemory, totalAvailableSize, totalGlobalHandlesSize, totalHeapSize, totalHeapSizeExecutable, totalPhysicalSize, usedGlobalHandlesSize, usedHeapSize);
    }

    @Override
    public boolean observe(V8Runtime v8Runtime) {
        this.v8HeapStatisticsList.add(v8Runtime.getV8HeapStatistics());
        return true;
    }

    @Override
    public void reset() {
        this.v8HeapStatisticsList.clear();
    }
}

