/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.callback;

import com.caoccao.javet.enums.V8ValueSymbolType;
import com.caoccao.javet.interop.callback.IJavetDirectCallable;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public final class JavetCallbackContext {
    public static final long INVALID_HANDLE = 0L;
    private static final String ERROR_CALLBACK_RECEIVER_OR_CALLBACK_METHOD_IS_INVALID = "Callback receiver or callback method is invalid";
    private static final String ERROR_CALLBACK_TYPE_MISMATCHES = "Callback type mismatches.";
    private static final String ERROR_JAVET_CALLBACK_CONTEXT_HANDLE_IS_INVALID = "Javet callback context handle is invalid";
    private final Object callbackMethod;
    private final Object callbackReceiver;
    private final JavetCallbackType callbackType;
    private final String name;
    private final V8ValueSymbolType symbolType;
    private final boolean thisObjectRequired;
    private long handle;
    private boolean returnResult;

    public JavetCallbackContext(String name, JavetCallbackType callbackType, IJavetDirectCallable.DirectCall directCall) {
        this(name, V8ValueSymbolType.None, callbackType, directCall);
    }

    public JavetCallbackContext(String name, Object callbackReceiver, JavetCallbackType callbackType, IJavetDirectCallable.DirectCall directCall) {
        this(Objects.requireNonNull(name), V8ValueSymbolType.None, callbackReceiver, callbackType, directCall);
    }

    public JavetCallbackContext(String name, V8ValueSymbolType symbolType, JavetCallbackType callbackType, IJavetDirectCallable.DirectCall directCall) {
        this(Objects.requireNonNull(name), symbolType, null, callbackType, directCall);
    }

    public JavetCallbackContext(String name, Object callbackReceiver, Method callbackMethod) {
        this(name, V8ValueSymbolType.None, callbackReceiver, callbackMethod);
    }

    public JavetCallbackContext(String name, V8ValueSymbolType symbolType, Object callbackReceiver, Method callbackMethod) {
        this(name, symbolType, callbackReceiver, callbackMethod, false);
    }

    public JavetCallbackContext(String name, Object callbackReceiver, Method callbackMethod, boolean thisObjectRequired) {
        this(name, V8ValueSymbolType.None, callbackReceiver, callbackMethod, thisObjectRequired);
    }

    public JavetCallbackContext(String name, V8ValueSymbolType symbolType, Object callbackReceiver, JavetCallbackType callbackType, IJavetDirectCallable.DirectCall directCall) {
        this(name, symbolType, callbackReceiver, Objects.requireNonNull(callbackType), directCall, callbackType.getThisObjectRequired());
        assert (callbackType.getDirectCallClass().isAssignableFrom(directCall.getClass())) : "Callback type mismatches.";
        this.returnResult = callbackType.getReturnResult();
    }

    public JavetCallbackContext(String name, V8ValueSymbolType symbolType, Object callbackReceiver, Method callbackMethod, boolean thisObjectRequired) {
        this(Objects.requireNonNull(name), symbolType, callbackReceiver, JavetCallbackType.Reflection, callbackMethod, thisObjectRequired);
        assert (callbackReceiver != null && !Modifier.isStatic(callbackMethod.getModifiers()) || callbackReceiver == null && Modifier.isStatic(callbackMethod.getModifiers())) : "Callback receiver or callback method is invalid";
        this.returnResult = !callbackMethod.getReturnType().equals(Void.TYPE);
    }

    private JavetCallbackContext(String name, V8ValueSymbolType symbolType, Object callbackReceiver, JavetCallbackType callbackType, Object callbackMethod, boolean thisObjectRequired) {
        this.callbackMethod = Objects.requireNonNull(callbackMethod);
        this.callbackReceiver = callbackReceiver;
        this.callbackType = Objects.requireNonNull(callbackType);
        this.handle = 0L;
        this.name = name;
        this.thisObjectRequired = thisObjectRequired;
        this.symbolType = Objects.requireNonNull(symbolType);
    }

    public <T> T getCallbackMethod() {
        return (T)this.callbackMethod;
    }

    public Object getCallbackReceiver() {
        return this.callbackReceiver;
    }

    public JavetCallbackType getCallbackType() {
        return this.callbackType;
    }

    public long getHandle() {
        return this.handle;
    }

    public String getName() {
        return this.name;
    }

    public V8ValueSymbolType getSymbolType() {
        return this.symbolType;
    }

    public boolean isReturnResult() {
        return this.returnResult;
    }

    public boolean isThisObjectRequired() {
        return this.thisObjectRequired;
    }

    public boolean isValid() {
        return this.handle != 0L;
    }

    void setHandle(long handle) {
        assert (!this.isValid()) : "Javet callback context handle is invalid";
        this.handle = handle;
    }
}

