/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.NodeNative;
import com.caoccao.javet.interop.V8Native;
import com.caoccao.javet.interop.loader.IJavetLibLoadingListener;
import com.caoccao.javet.interop.loader.JavetLibLoader;
import com.caoccao.javet.utils.JavetOSUtils;
import com.caoccao.javet.utils.JavetReflectionUtils;
import com.caoccao.javet.utils.SimpleMap;
import java.lang.reflect.Constructor;
import java.util.Objects;

class JavetClassLoader
extends ClassLoader {
    protected static final String ERROR_NODE_JS_IS_NOT_SUPPORTED_ON_ANDROID = "Node.js is not supported on Android.";
    protected static final String JAVET_LIB_LOADER_CLASS_NAME = JavetLibLoader.class.getName();
    protected static final String METHOD_LOAD = "load";
    protected static final String METHOD_SET_LIB_LOADING_LISTENER = "setLibLoadingListener";
    protected static final String NODE_NATIVE_CLASS_NAME = NodeNative.class.getName();
    protected static final String V8_NATIVE_CLASS_NAME = V8Native.class.getName();
    protected JSRuntimeType jsRuntimeType;

    JavetClassLoader(ClassLoader parent, JSRuntimeType jsRuntimeType) {
        super(parent);
        Objects.requireNonNull(jsRuntimeType);
        this.jsRuntimeType = jsRuntimeType;
    }

    IV8Native getNative() throws JavetException {
        if (JavetOSUtils.IS_ANDROID) {
            if (this.jsRuntimeType.isNode()) {
                throw new JavetException(JavetError.LibraryNotLoaded, SimpleMap.of("reason", ERROR_NODE_JS_IS_NOT_SUPPORTED_ON_ANDROID));
            }
            return new V8Native();
        }
        try {
            Class<?> classNative = this.loadClass(this.jsRuntimeType.isNode() ? NODE_NATIVE_CLASS_NAME : V8_NATIVE_CLASS_NAME);
            Constructor<?> constructor = classNative.getDeclaredConstructor(new Class[0]);
            JavetReflectionUtils.safeSetAccessible(constructor);
            return (IV8Native)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new JavetException(JavetError.LibraryNotLoaded, SimpleMap.of("reason", e.getMessage()), e);
        }
    }

    void load() throws JavetException {
        if (JavetOSUtils.IS_ANDROID) {
            if (this.jsRuntimeType.isNode()) {
                throw new JavetException(JavetError.LibraryNotLoaded, SimpleMap.of("reason", ERROR_NODE_JS_IS_NOT_SUPPORTED_ON_ANDROID));
            }
            JavetLibLoader javetLibLoader = new JavetLibLoader(this.jsRuntimeType);
            javetLibLoader.load();
        } else {
            try {
                Class<?> classJavetLibLoader = this.loadClass(JAVET_LIB_LOADER_CLASS_NAME);
                Constructor<?> constructor = classJavetLibLoader.getConstructor(JSRuntimeType.class);
                Object javetLibLoader = constructor.newInstance(new Object[]{this.jsRuntimeType});
                classJavetLibLoader.getMethod(METHOD_SET_LIB_LOADING_LISTENER, IJavetLibLoadingListener.class).invoke(null, JavetLibLoader.getLibLoadingListener());
                classJavetLibLoader.getMethod(METHOD_LOAD, new Class[0]).invoke(javetLibLoader, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new JavetException(JavetError.LibraryNotLoaded, SimpleMap.of("reason", e.getMessage()), e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

