/*
 * Decompiled with CFR 0.152.
 */
package com.callcontrol.datashare;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public final class CallControl {
    public static final String AUTHORITY = "com.callcontrol.datashare";
    public static final Uri AUTHORITY_URI = Uri.parse((String)"content://com.callcontrol.datashare");
    public static final Uri LOOKUP_CALL_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"lookup/call");
    public static final Uri LOOKUP_TEXT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"lookup/text");
    public static final Uri REQUEST_TOKEN_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"token");
    public static final String MIME_TYPE_LOOKUP_RESULT = "vnd.android.cursor.item/lookup_result";
    public static final String MIME_TYPE_TOKEN_RESULT = "vnd.android.cursor.item/token_result";
    public static final String ACTION_BLOCKED_LIST = "com.callcontrol.datashare.intent.action.BLOCKED_LIST";
    public static final String ACTION_LOOKUP = "com.callcontrol.datashare.intent.action.LOOKUP";
    public static final String ACTION_ADD_RULE = "com.callcontrol.datashare.intent.action.ADD_RULE";
    public static final String ACTION_REPORT = "com.callcontrol.datashare.intent.action.REPORT";
    public static final String ACTION_3RD_PARTY_ACCESS = "com.callcontrol.datashare.intent.action.3RD_PARTY_ACCESS";
    public static final String EXTRA_PHONE_NUMBER = "com.callcontrol.datashare.intent.extra.PHONE_NUMBER";
    public static final String EXTRA_TOKEN = "com.callcontrol.datashare.intent.extra.TOKEN";

    private CallControl() {
    }

    public static boolean openBlockedList(@NonNull Context context) {
        return CallControl.openBlockedList(context, null, 0);
    }

    public static boolean openBlockedList(@NonNull Context context, int n) {
        return CallControl.openBlockedList(context, null, n);
    }

    public static boolean openBlockedList(@NonNull Context context, @Nullable String string) {
        return CallControl.openBlockedList(context, string, 0);
    }

    public static boolean openBlockedList(@NonNull Context context, @Nullable String string, int n) {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent(ACTION_BLOCKED_LIST);
        if (string != null) {
            intent2.putExtra(EXTRA_PHONE_NUMBER, string);
        }
        if (n != 0) {
            intent2.setFlags(n);
        }
        if (!CallControl.signIntent(context, intent2)) {
            return false;
        }
        context.startActivity(intent2);
        return true;
    }

    public static boolean lookupNumber(@NonNull Context context, @NonNull String string) {
        return CallControl.lookupNumber(context, string, 0);
    }

    public static boolean lookupNumber(@NonNull Context context, @NonNull String string, int n) {
        Intent intent;
        Intent intent2 = intent;
        new Intent(ACTION_LOOKUP).putExtra(EXTRA_PHONE_NUMBER, string);
        if (n != 0) {
            intent2.setFlags(n);
        }
        if (!CallControl.signIntent(context, intent2)) {
            return false;
        }
        context.startActivity(intent2);
        return true;
    }

    public static boolean addRule(@NonNull Context context, @NonNull Report report) {
        return CallControl.addRule(context, report, 0);
    }

    public static boolean addRule(@NonNull Context context, @NonNull Report report, int n) {
        ArrayList<Report> arrayList = new ArrayList<Report>(1);
        arrayList.add(report);
        return CallControl.addRule(context, arrayList, n);
    }

    public static boolean addRule(@NonNull Context context, @NonNull ArrayList<Report> arrayList) {
        return CallControl.addRule(context, arrayList, 0);
    }

    public static boolean addRule(@NonNull Context context, @NonNull ArrayList<Report> arrayList, int n) {
        Intent intent;
        if (arrayList.isEmpty()) {
            return false;
        }
        ArrayList<Report> arrayList2 = arrayList;
        boolean bl = arrayList2.get(0).isUnwanted;
        Iterator<Report> iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isUnwanted == bl) continue;
            throw new IllegalArgumentException("All numbers reported must have identical isUnwanted flag");
        }
        Intent intent2 = intent;
        new Intent(ACTION_ADD_RULE).putExtra(EXTRA_PHONE_NUMBER, arrayList);
        if (n != 0) {
            intent2.setFlags(n);
        }
        if (!CallControl.signIntent(context, intent2)) {
            return false;
        }
        context.startActivity(intent2);
        return true;
    }

    public static boolean report(@NonNull Context context, @NonNull Report report) {
        return CallControl.report(context, report, 0);
    }

    public static boolean report(@NonNull Context context, @NonNull Report report, int n) {
        ArrayList<Report> arrayList = new ArrayList<Report>(1);
        arrayList.add(report);
        return CallControl.report(context, arrayList, n);
    }

    public static boolean report(@NonNull Context context, @NonNull ArrayList<Report> arrayList) {
        return CallControl.report(context, arrayList, 0);
    }

    public static boolean report(@NonNull Context context, @NonNull ArrayList<Report> arrayList, int n) {
        Intent intent;
        if (arrayList.isEmpty()) {
            return false;
        }
        ArrayList<Report> arrayList2 = arrayList;
        boolean bl = arrayList2.get(0).isUnwanted;
        Iterator<Report> iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isUnwanted == bl) continue;
            throw new IllegalArgumentException("All numbers reported must have identical isUnwanted flag");
        }
        Intent intent2 = intent;
        new Intent(ACTION_REPORT).putExtra(EXTRA_PHONE_NUMBER, arrayList);
        if (n != 0) {
            intent2.setFlags(n);
        }
        if (!CallControl.signIntent(context, intent2)) {
            return false;
        }
        context.startActivity(intent2);
        return true;
    }

    public static boolean openAccessSettings(@NonNull Context context) {
        return CallControl.openAccessSettings(context, 0);
    }

    public static boolean openAccessSettings(@NonNull Context context, int n) {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent(ACTION_3RD_PARTY_ACCESS);
        if (n != 0) {
            intent2.setFlags(n);
        }
        if (!CallControl.signIntent(context, intent2)) {
            return false;
        }
        context.startActivity(intent2);
        return true;
    }

    private static boolean signIntent(@NonNull Context object, @NonNull Intent intent) {
        String string;
        Cursor cursor;
        long l;
        block18: {
            block17: {
                Context context;
                Context context2;
                try {
                    Context context3 = object;
                    context2 = context3;
                    context = context3;
                    l = System.currentTimeMillis();
                }
                catch (Throwable throwable) {
                    return false;
                }
                object = context2.getPackageName();
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri = REQUEST_TOKEN_URI;
                String string2 = "ts = ?";
                String[] stringArray = new String[1];
                int n = 0;
                stringArray[n] = String.valueOf(l);
                cursor = contentResolver.query(uri, null, string2, stringArray, null);
                if (cursor != null) break block17;
                return false;
            }
            Cursor cursor2 = cursor;
            string = "";
            if (!cursor2.moveToFirst()) break block18;
            Cursor cursor3 = cursor;
            string = cursor3.getString(cursor3.getColumnIndex("token"));
        }
        Intent intent2 = intent;
        String string3 = string;
        cursor.close();
        int n = 8;
        int n2 = string3.getBytes().length;
        int n3 = n2 + n + ((String)object).getBytes().length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        Object object2 = object;
        ByteBuffer byteBuffer2 = byteBuffer;
        String string4 = string;
        byteBuffer.putLong(l);
        byteBuffer2.put(string4.getBytes());
        byteBuffer.put(((String)object2).getBytes());
        intent2.putExtra(EXTRA_TOKEN, new String(Base64.encode((byte[])byteBuffer.array(), (int)0)));
        return true;
    }

    public static final class Report
    implements Parcelable {
        public static final Parcelable.Creator<Report> CREATOR = new Parcelable.Creator<Report>(){

            public Report createFromParcel(Parcel parcel) {
                return new Report(parcel);
            }

            public Report[] newArray(int n) {
                return new Report[n];
            }
        };
        private String number;
        private String name;
        private boolean isUnwanted;

        public Report(@NonNull String string) {
            this(string, null, true);
        }

        public Report(@NonNull String string, @Nullable String string2) {
            this(string, string2, true);
        }

        public Report(@NonNull String string, @Nullable String string2, boolean bl) {
            this.number = string;
            this.name = string2;
            this.isUnwanted = bl;
        }

        public Report(Parcel parcel) {
            this.number = parcel.readString();
            this.name = parcel.readString();
            boolean bl = parcel.readInt() == 1;
            this.isUnwanted = bl;
        }

        @NonNull
        public String getNumber() {
            return this.number;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public boolean isUnwanted() {
            return this.isUnwanted;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.number);
            parcel.writeString(this.name);
            parcel.writeInt(this.isUnwanted ? 1 : 0);
        }

        public int describeContents() {
            return 0;
        }
    }

    public static final class Token {
        public static final String TOKEN = "token";
        public static final String TIMESTAMP = "ts";

        private Token() {
        }
    }

    public static final class Lookup {
        public static final String BLOCK_REASON = "reason";
        public static final String DISPLAY_NAME = "name";

        private Lookup() {
        }
    }
}

