/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.web.servlet.request;

import com.c4_soft.oauth2.UnmodifiableClaimSet;
import com.c4_soft.springaddons.test.security.support.ClaimSetAuthenticationTestingBuilder;
import com.c4_soft.springaddons.test.security.support.Defaults;
import com.c4_soft.springaddons.test.security.web.servlet.request.ServletUnitTestingSupport;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;

@Import(value={UnitTestConfig.class})
public abstract class ServletClaimSetAuthenticationUnitTestingSupport<T extends UnmodifiableClaimSet, U extends ClaimSetAuthenticationTestingBuilder<T, U>>
extends ServletUnitTestingSupport {
    public abstract U authentication();

    public U authentication(Consumer<Map<String, Object>> claimsConsumer) {
        U requestPostProcessor = this.authentication();
        ((ClaimSetAuthenticationTestingBuilder)requestPostProcessor).claims(claimsConsumer);
        return requestPostProcessor;
    }

    @TestConfiguration
    public static class UnitTestConfig<T extends UnmodifiableClaimSet> {
        @ConditionalOnMissingBean
        @Bean
        @Scope(value="prototype")
        public Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter() {
            ClaimSet2AuthoritiesConverter mockAuthoritiesConverter = (ClaimSet2AuthoritiesConverter)Mockito.mock(ClaimSet2AuthoritiesConverter.class);
            Mockito.when((Object)((Set)mockAuthoritiesConverter.convert((Map)ArgumentMatchers.any()))).thenReturn(Defaults.GRANTED_AUTHORITIES);
            return mockAuthoritiesConverter;
        }

        private static interface ClaimSet2AuthoritiesConverter
        extends Converter<Map<String, Object>, Set<GrantedAuthority>> {
        }
    }
}

