/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.support.missingpublicapi;

import com.c4_soft.oauth2.rfc7662.IntrospectionClaimSet;
import java.util.Map;
import java.util.function.Consumer;

public class OAuth2IntrospectionToken {
    private final String value;
    private final IntrospectionClaimSet attributes;

    public OAuth2IntrospectionToken(String value, Map<String, Object> attributes) {
        this.value = value;
        this.attributes = new IntrospectionClaimSet(attributes);
    }

    public String getTokenValue() {
        return this.value;
    }

    public IntrospectionClaimSet getAttributes() {
        return this.attributes;
    }

    public static OAuth2IntrospectionTokenBuilder<?> builder() {
        return new OAuth2IntrospectionTokenBuilder();
    }

    public static class OAuth2IntrospectionTokenBuilder<T extends OAuth2IntrospectionTokenBuilder<T>> {
        private String value;
        private final IntrospectionClaimSet.Builder<?> attributes = IntrospectionClaimSet.builder();

        public T attributes(Consumer<IntrospectionClaimSet.Builder<?>> attributesBuilderConsumer) {
            attributesBuilderConsumer.accept(this.attributes);
            return this.downcast();
        }

        public T value(String tokenValue) {
            this.value = tokenValue;
            return this.downcast();
        }

        public OAuth2IntrospectionToken build() {
            return new OAuth2IntrospectionToken(this.value, (Map<String, Object>)this.attributes.build());
        }

        protected T downcast() {
            return (T)this;
        }
    }
}

